#pragma C+


/*
 *  TADSMap
 *
 *  An HTML-based mapping libary 
 *  Copyright (c) 2001-2002 Andrew Pontious
 *  All rights reserved. 
 *  Anyone may use and modify this code for their own TADS games.
 *
 *  http://www.umbar.com/TADS/tadsmap/
 *
 *  Version 1.0
 *
 *  July 2002
 *
 */
 
 
 /*
  *  tadsmap_verbs.t
  *
  *  Modified and new verbs
  */




 /*
  *  The standard travel verbs have been modified so that we
  *  can record when a player moves in a particular direction.
  *  This allows us to know when a particular hallway has been
  *  taken, and it will then be mapped instead of being left
  *  as hidden.
  *
  *  Hallways will be mapped if the "xx_taken" property of
  *  either adjoining room has been set to true.
  *
  *  Note anyone else subclassing these verbs should be fine if
  *  we subclass after them, because we call inherited.
  *  If all other TADS libraries do the same, these modifications
  *  should coexist nicely with any others.
  */




modify eVerb
    travelDir(actor) = 
    { 
    	actor.location.east_taken = true;
    	
    	return inherited.travelDir(actor); 
    }
;
modify sVerb
    travelDir(actor) = 
    {
		actor.location.south_taken = true;
    	
    	return inherited.travelDir(actor); 
    }
;
modify nVerb
    travelDir(actor) = 
    {	
		actor.location.north_taken = true;
    	
    	return inherited.travelDir(actor); 
    }
;
modify wVerb
    travelDir(actor) = 
    {	
		actor.location.west_taken = true;
    	
    	return inherited.travelDir(actor); 
    }
;
modify neVerb
    travelDir(actor) = 
    {	
		actor.location.ne_taken = true;
    	
    	return inherited.travelDir(actor); 
    }
;
modify nwVerb
    travelDir(actor) = 
    {	
		actor.location.nw_taken = true;
    	
    	return inherited.travelDir(actor); 
    }
;
modify seVerb
    travelDir(actor) = 
    {	
		actor.location.se_taken = true;
    	
    	return inherited.travelDir(actor); 
    }
;
modify swVerb
    travelDir(actor) = 
    {	
		actor.location.sw_taken = true;
    	
    	return inherited.travelDir(actor); 
    }
;




 /*
  *  New TADSMap verbs
  */




class tadsmapverb: sysverb
	istadsmapverb = true
	
	// Bit of shorthand: subclasses don't need to have "abort" call.
	action(actor) =
	{
		self.doTADSMapAction;
		abort;
	}
	
	// Some verbs only need to know if you *can* map before allowing you to proceed.
	can_map =
	{
		if(!tadsmap.can_map)
		{
			"[TADSMap cannot run on this TADS interpreter, because it does not support HTML.]\n";
			return nil;
		}
		else return true;
	}
	
	// Most verbs need to know if you *should* be mapping (is map shown) before
	// allowing you to proceed.
	should_map =
	{
		if(!self.can_map)
			return nil;
		else
		{
			if(!tadsmap.should_map)
			{
				"[The map is currently hidden. Type MAPSHOW first to show the map.]\n";
				return nil;
			}
			else return true;
		}
	}
;




TMShowVerb: tadsmapverb
	verb = 'mapshow' 'mshow'
	sdesc = "MapShow"

	doTADSMapAction =
	{
		if(self.can_map)
			tadsmap.show;
	}
;
TMHideVerb: tadsmapverb
	verb = 'maphide' 'mhide'
	sdesc = "MapHide"

	doTADSMapAction =
	{
		if(self.can_map)
			tadsmap.hide;
	}
;




TMAboveVerb: tadsmapverb
	verb = 'mapabove' 'mabove' 'maptop' 'mtop'
	sdesc = "MapAbove"

	doTADSMapAction =
	{
		if(self.should_map)
			tadsmap.move_to_above;
	}
;
TMBelowVerb: tadsmapverb
	verb = 'mapbelow' 'mbelow' 'mapbottom' 'mbottom'
	sdesc = "MapBelow"

	doTADSMapAction =
	{
		if(self.should_map)
			tadsmap.move_to_below;
	}
;
TMRightVerb: tadsmapverb
	verb = 'mapright' 'mright'
	sdesc = "MapRight"

	doTADSMapAction =
	{
		if(self.should_map)
			tadsmap.move_to_right;
	}
;
TMLeftVerb: tadsmapverb
	verb = 'mapleft' 'mleft'
	sdesc = "MapLeft"

	doTADSMapAction =
	{
		if(self.should_map)
			tadsmap.move_to_left;
	}
;




TMAWiderVerb: tadsmapverb
	verb = 'mapwider' 'mwider' 'mapwide' 'mwide'
	sdesc = "MapWider"

	doTADSMapAction =
	{
		if(self.should_map)
			tadsmap.make_wider;
	}
;
TMNarrowerVerb: tadsmapverb
	verb = 'mapnarrower' 'mnarrower' 'mapnarrow' 'mnarrow'
	sdesc = "MapNarrower"

	doTADSMapAction =
	{
		if(self.should_map)
			tadsmap.make_narrower;
	}
;
TMTallerVerb: tadsmapverb
	verb = 'maptaller' 'mtaller' 'maptall' 'mtall'
	sdesc = "MapTaller"

	doTADSMapAction =
	{
		if(self.should_map)
			tadsmap.make_taller;
	}
;
TMShorterVerb: tadsmapverb
	verb = 'mapshorter' 'mshorter' 'mapshort' 'mshort'
	sdesc = "MapShorter"

	doTADSMapAction =
	{
		if(self.should_map)
			tadsmap.make_shorter;
	}
;




TMGotoVerb: tadsmapverb
	verb = 'mapgoto' 'mgoto'
	sdesc = "MapGoto"

	/*
	 *  The entry point for the MGOTO verb, unlikely as it seems!
	 *
     *  When map is shown, user can type in commands like:
     *
     *       MGOTO 0, 2
     *       MGOTO 4, 5
     *
     *  and we'll use the GOTO module to attempt to get to the
     *  room at those coordinates.
     *
     *  Because the format of such a sentence isn't recognized by
     *  the parser, you'll get this error:
     *
     *      24 - I don't recognize that sentence.
     *
     *  We take over at that point.
     */  
	parseUnknown(actor, wordlist, typelist, errnum) =
	{
		local i, xcoord, ycoord, map_entry, goto_result;
		
		// Don't go any further if:
		// - Isn't our error number.
		if(errnum != 24 ||
		// - actor isn't player
		   actor != parserGetMe() ||
		// - word and type list aren't 4 long (mapgoto 0, 0 -> 4 words and types).
		   length(wordlist) < 4 || length(typelist) < 4 ||
		// - First word isn't one of our vocabulary words
		   typelist[1] != PRSTYP_VERB || !self.stringMatchesVerb(wordlist[1]) ||
		// - Third word isn't ',' (could have been "AND" in actual typed words)
		   typelist[3] != PRSTYP_SPEC || wordlist[3] != ',' ||
		// - Second and fourth words aren't numbers (negative numbers are "UNKNOWN")
		   (typelist[2] != PRSTYP_SPEC && typelist[2] != PRSTYP_UNKNOWN) || 
		   (typelist[4] != PRSTYP_SPEC && typelist[4] != PRSTYP_UNKNOWN) ||
		   cvtstr( (xcoord = cvtnum(wordlist[2])) ) != wordlist[2] ||
		   cvtstr( (ycoord = cvtnum(wordlist[4])) ) != wordlist[4]
		)
		{
			return nil;
		}

        // Coordinates aren't updated properly if map isn't being shown,
        // so show user error message if they try to use commands when map is hidden
        // (or if TADSMap can't run at all due to lack of HTML support).
		if(!self.should_map)
		{}
		else if(xcoord < 0)
		{
			"The X coordinate must be greater than zero.\n";
		}
		else if(ycoord < 0)
		{
			"The Y coordinate must be greater than zero.\n";
		}
		else if(xcoord >= tadsmap.entries_across)
		{
			"The X coordinate is greater than the width of the map.\n";
		}
		else if(ycoord >= tadsmap.entries_down)
		{
			"The X coordinate is greater than the width of the map.\n";
		}
		else
		{
			map_entry = tadsmap.entry_for_xandy(xcoord+1, ycoord+1);
			if(map_entry.map_room == nil)
			{
				"Those coordinates contain no known location to go to.\n";
			}
			else if(xcoord+1 == tadsmap.current_entry_x && ycoord+1 == tadsmap.current_entry_y)
			{
				"You're already at that location!\n";
			}
			else
			{
  				// Call GOTO module's verb.
  				tadsmap.going = true;
  				
  				goto_result = execCommand(parserGetMe(), goToVerb, map_entry.map_room, nil, nil, 0);

  				tadsmap.going = nil;

  				if(goto_result == EC_SUCCESS)
  				{
  					tadsmap.map;
  				}
			}
		}
		
		// Continue parsing at the word after the command we just handled.
		return 5;
	}
	
	stringMatchesVerb(string) =
	{
		local i, verbStrings = getwords(self, &verb);
		
		for(i = 1; i <= length(verbStrings); i++)
		{
			if(verbStrings[i] == string)
			{
				return true;
			}
		}
		
		return nil;
	}
;




TMControlsVerb: tadsmapverb
	verb = 'mapcontrols' 'mcontrols' 'mapcon' 'mcon'
	sdesc = "MapControls"

	doTADSMapAction =
	{
		if(self.can_map)
			tadsmap.show_controls;
	}
;
TMNoControlsVerb: tadsmapverb
	verb = 'mapnocontrols' 'mnocontrols' 'mapnocon' 'mnocon'
	sdesc = "MapNoControls"

	doTADSMapAction =
	{
		if(self.can_map)
			tadsmap.hide_controls;
	}
;




#pragma C-
