////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Connection 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//  Based on ADV3 (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _CONNECTION_H_
#define _CONNECTION_H_

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  Connection: object
 *
 *  Acts as a one-way conduit for sense-passing between different 
 *  locations.
 */
class Connection: object
    isConnection = true
    senseDest = nil
    connectorMaterial = altima
    findDest = {
        if (self.senseDest)
            return [self.senseDest];
        else return self.noLocations;
    }
    noLocations = {return [];}
    
    /*
     *  Returns a list of the Connection location. If object has no 
     *	location then the method returns an empty list. This method 
     *  is used by scope() to build a path that connects all of the 
     *  object's possible locations.
     */
    getLocationsList = {
        if (self.location)
            return self.findDest;
        else return noLocations;
    }
    
    /*
     *  Does the object allow its contents to be sensed?
     */
    canSenseContents(sense, isVantage) = {
        return self.canSenseLocations(sense, isVantage);
    }
    
    /*
     *  Does the object allow its location(s) to be searched? In this
     *  case we simply default to canSenseContents.
     */
    canSenseLocations(sense, isVantage) = {
        if (isVantage) 
            return true;
        else 
            return connectorMaterial.senseThru(sense);
    }
; 

#pragma C-

#endif  /* _CONNECTION_H_ */
