////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: DistantItem 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _DISTANT_ITEM_H_
#define _DISTANT_ITEM_H_

#include <fixeditem.h>

#pragma C+

/*
 *  DistantItem: FixedItem
 *
 *  This is an Item that is too far away to manipulate, but can be seen.
 *  The class uses dobjGen and iobjGen to prevent any verbs from being
 *  used on the object apart from inspectVerb; using any other verb results
 *  in the message "It's too far away."  Instances of this class should
 *  provide the normal item properties:  sDesc, lDesc, location,
 *  and vocabulary.
 */
class DistantItem: FixedItem
    dobjGen(a, v, i, p) = {
        if (v != askVerb && v != tellVerb && v != inspectVerb) {
            "\^<<self.itIsDesc>> too far away.";
            exit;
        }
    }
    iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
;

#pragma C-

#endif /* _DISTANT_ITEM_H_ */
