////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: KeyedLockable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _KEYED_LOCKABLE_H_
#define _KEYED_LOCKABLE_H_

#include <lockable.h>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  KeyedLockable: Lockable
 *
 *  This subclass of Lockable allows you to create an object
 *  that can only be locked and unlocked with a corresponding key.
 *  Set the property myKey to the KeyItem object that can
 *  lock and unlock the object.
 */
class KeyedLockable: Lockable
    isKeyedLockable = true
    doLock(actor) = {
        askForIobj(withPrep);
    }
    doLockWith(actor, io) = {
        if (self.isOpen) {
            "%You% can't lock << self.theDesc >> when <<
            self.itisDesc>> open. ";
        } else if (io == self.myKey) {
            "Locked. ";
            self.isLocked = true;
        }
        else
            "\^<<io.itNomDesc>> <<io.doesDesc>>n't fit the lock. ";
    }
    doUnlock(actor) = {
        askForIobj(withPrep);
    }
    doUnlockWith(actor, io) = {
        if (io == self.myKey) {
            "Unlocked. ";
            self.isLocked = nil;
        }
        else
            "\^<<io.itNomDesc>> <<io.doesDesc>>n't fit the lock. ";
    }
;

#pragma C-

#endif /* _KEYED_LOCKABLE_H_ */
