////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: ListGroup 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _LIST_GROUP_H_
#define _LIST_GROUP_H_

#include <listcontgen.t>

#pragma C+

/*
 *  ListGroup: object
 *
 */
class ListGroup: object
    groupList_ = []
    beginList = {
        // initialize groupList
        self.groupList_ = [];
    }
    addList(obj) = {
        // add obj to groupList
        self.groupList_ += obj;
    }
    /*
     *  showList is passed the &desc pointer, which was passed to
     *  listContGen(). If the group consists of one member then we can
     *  pass listContGen() back the desc argument we received from it. 
     *  Otherwise we should pass listContGen() the &groupDesc for desc.
     *
     *  showList must *always* use the LCG_NOLISTGROUP flag so that
     *  grouping is bypassed at this stage and we produce an ordinary
     *  listContGen() list.
     */
    showList(desc, flags, indent) = {
        listContGen(self.groupList_, &groupDesc, flags|LCG_NOLISTGROUP, indent);
    }
    /*
     *  Returns the count of all listable objects in our groupList_
     */
    getSizeOfGroup = {
        local i, cnt = 0;
        
        for (i = 1; i <= length(self.groupList_); ++i) {
            if (self.groupList_[i].isListed) ++cnt;
        }
        return cnt;
    }
;

#pragma C-

#endif /* _LIST_GROUP_H_ */
