////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: SackItem 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _SACK_ITEM_H_
#define _SACK_ITEM_H_

#include <wearable.h>
#include <openablecontainer.h>
#include <addbulk.t>

#pragma C+

/*
 *	SackItem: Wearable, OpenableContainer
 *
 *	This class allows an object to act like a 'rucksack', into which the
 *	game automatically tidies away things for the player.
 */
 
class SackItem: Wearable, OpenableContainer
	maxBulk = 100
    invDesc = {
        /* show any additional information about the item */
        if (self.isWorn)
            " (being worn)";
    }
    /*
     *	This is the heart of the SackItem logic. The logic does not 
     *	check for multiple SackItems, it takes the first one it finds
     *	Also it does not attempt to optimise the placement of items
     *	in the SackItem, except that items that are lit or that are
     *	being worn are not chosen.
     */
    moveToSackItem(actor) = {
    	local c, o, n = [], totBulk, s;
    	
    	s = self;
    	
		c = actor.contents - [ s ];	// exclude the sackItem
 	    /*
 	     *	Select items that aren't being worn or that aren't lit as 
 	     *	candidates for the SackItem.
 	     */		
		o = car( c );
		while( o ) {
			if ( !o.isWorn && !o.lightsOn ) {
				n += [ o ];
			}
			c = cdr( c );
			o = car( c );
		}
        /*
         *	Determine if an object will fit in the sack and move it
         *	if it does.
         */	
     	o = car( n );
    	while( o ) {
			totBulk = addBulk(s.contents) + o.bulk;
				
			if (totBulk <= s.maxBulk) {
				o.moveInto(s);
				"(putting <<o.theDesc>> into <<s.theDesc>> to make room)\n";
			}
			
			n = cdr( n );
			o = car( n );
    	}
    }
    scopePreAction = {
        if (gVerb() == takeVerb && gDobj() && self.isWornBy(gActor())) {
            local totBulk = addBulk(self.wearer.contents) +
                gDobj().bulk;
            if (totBulk > self.wearer.maxBulk)
                self.moveToSackItem(gActor());
        }
    }
    moveInto(obj) = {
        /*
         *   Catch any other movements with moveInto; this won't stop the
         *   movement from happening, but it will prevent any anamolous
         *   consequences caused by the object moving but still being worn.
         */
        self.wearer = nil;
        pass moveInto;
    }
    checkDrop = {
        if (self.isWornBy(gActor())) {
            "(Taking off _dobj_ first)\n";
            self.wearer = nil;
        }
    }
    doDrop(actor) = {
        self.checkDrop;
        pass doDrop;
    }
    doGiveTo(actor, io) = {
        self.checkDrop;
        pass doGiveTo;
    }
    doPutIn(actor, io) = {
        self.checkDrop;
        pass doPutIn;
    }
    doPutOn(actor, io) = {
        self.checkDrop;
        pass doPutOn;
    }
    verDoTake(actor) = {
        if (self.isWornBy(actor))
            self.verDoUnwear(actor);
        else
            pass verDoTake;
    }
    doTake(actor) = {
        if (self.isWornBy(actor))
            self.doUnwear(actor);
        else
            pass doTake;
    }
    doThrow(actor) = {
        self.checkDrop;
        pass doThrow;
    }
    doThrowAt(actor, io) = {
        self.checkDrop;
        pass doThrowAt;
    }
    doThrowTo(actor, io) = {
        self.checkDrop;
        pass doThrowTo;
    }
;

#pragma C-

#endif /* _SACK_ITEM_H_ */
