////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: SeethruItem 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _SEETHRU_ITEM_H_
#define _SEETHRU_ITEM_H_

#include <item.h>

#pragma C+

/*
 *  SeethruItem: Item
 *
 *  This is an object that the player can look through, such as a window.
 *  The thrudesc method displays a message for when the player looks
 *  through the object (with a command such as "look through window").
 *  Note this is not the same as a TransparentItem, whose contents
 *  are visible from outside the object.
 */
class SeethruItem: Item
    thruDesc = nil
    verDoLookthru(actor) = {}
    doLookthru(actor) = { self.thruDesc; }
;

#pragma C-

#endif /* _SEETHRU_ITEM_H_ */
