////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: VehicularTravelable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _VEHICULAR_TRAVELABLE_H_
#define _VEHICULAR_TRAVELABLE_H_

#include <nestedroomtravelable.h>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  VehicularTravelable: NestedRoomTravelable
 */
class VehicularTravelable: NestedRoomTravelable
    boardingPosture = sitting
    verDoBoard(actor) = {
        if (actor.location == self 
        && actor.posture == self.boardingPosture) {
            "%You're% already <<self.boardingPrep>> <<self.theDesc>>! ";
        } else if (actor.isCarrying(self)) {
            "%You%'ll have to drop <<self.theDesc>> first!";
        }
    }
    doBoard(actor) = {
        actor.moveInto(self);
        actor.posture = self.boardingPosture;
        "Okay, %you're% now <<actor.posture.desc>> 
        <<self.boardingPrep>> <<self.theDesc>>. ";
    }
    verDoEnter(actor) = { self.verDoBoard(actor); }
    doEnter(actor) = { self.doBoard(actor); }
    out = (self.location)
    noExit = {
        "%You're% not going anywhere until %you% get%s% <<self.unboardingPrep>> <<
            self.theDesc>>. ";
        return nil;
    }
;

#pragma C-

#endif /* _VEHICULAR_TRAVELABLE_H_ */
