////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: askForIobj() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _ASK_FOR_IOBJ_T_
#define _ASK_FOR_IOBJ_T_

#include <global.t>

#pragma C+

/*
 *  askForIobj: function(prep)
 *
 *  This is a simple cover function for the built-in function askio().
 *  This cover function displays any outcaptured display. Note, that
 *  askio() does not return.
 */
askForIobj: function(prep) {
    local str;

    /* Capture any outcapture text and display it. */
    str = nestOutcapture(nil, true);
    say(str);
    
    /* ask for iobj */
    switch(prep) {
        case aboutPrep: askio(aboutPrep);
        case aroundPrep: askio(aroundPrep);
        case atPrep: askio(atPrep);
        case behindPrep: askio(behindPrep);
        case betweenPrep: askio(betweenPrep);
        case dirPrep: askio(dirPrep);
        case forPrep: askio(forPrep);
        case fromPrep: askio(fromPrep);
        case inPrep: askio(inPrep);
        case ofPrep: askio(ofPrep);
        case offPrep: askio(offPrep);
        case onPrep: askio(onPrep);
        case outPrep: askio(outPrep);
        case overPrep: askio(overPrep);
        case thruPrep: askio(thruPrep);
        case toPrep: askio(toPrep);
        case underPrep: askio(underPrep);
        case withPrep: askio(withPrep);
    }
}

#pragma C-

#endif /* _ASK_FOR_IOBJ_T_ */
