////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: child() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _CHILD_T_
#define _CHILD_T_

#pragma C+

/*
 *  child: function(o)
 *
 *  Function merely returns the last object of a contents list.
 *  If the object has no children then the function returns nil.
 */
child: function(o) {
    local len;
    if (o == nil) return nil;
    len = length(o.contents);
    if (len == 0) return nil;
    return o.contents[len];
}

#pragma C-

#endif /* _CHILD_T_ */
