////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: inputLine() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _INPUT_LINE_T_
#define _INPUT_LINE_T_

#include <global.t>

#pragma C+

/*
 *  inputLine: function
 *
 *  This is a simple cover function for the built-in function input().
 *  This cover function switches to the 'TADS-Input' font when running in
 *  HTML mode, so that input explicitly read through this function appears
 *  in the same input font that is used for normal command-line input.
 */
inputLine: function {
    local ret, str;
    local html_mode;

    /* note whether we're in HTML mode */
    html_mode = (systemInfo(__SYSINFO_SYSINFO) == true
                  && systemInfo(__SYSINFO_HTML_MODE));

    /* if in HTML mode, switch to TADS-Input font */
    if (html_mode)
        "<font face='TADS-Input'>";

    /* Capture any outcapture text and display it. */
    str = nestOutcapture(nil, true);
    say(str);
    
    /* read the input */
    ret = input();

    /* exit TADS-Input font mode if appropriate */
    if (html_mode)
        "</font>";
    
    /* if outcapturing was set then reset it. */
    if (global.outcaptureStatus != nil)
        nestOutcapture(true);
        
    /* return the line of text */
    return ret;
}

#endif /* _INPUT_LINE_T_ */
