////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: listCont() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _LIST_CONT_T_
#define _LIST_CONT_T_

#include <listcontgen.t>

#pragma C+

/*
 *  listCont: function(obj)
 *
 *  This function displays the contents of an object, separated by
 *  commas.  The theDesc properties of the contents are used.
 *  It is up to the caller to provide the introduction to the list
 *  (usually something to the effect of "The box contains" is
 *  displayed before calling listCont) and finishing the
 *  sentence (usually by displaying a period).  An object is listed
 *  only if its isListed property is true.  If there are
 *  multiple indistinguishable items in the list, the items are
 *  listed only once (with the number of the items).
 */
listCont: function(obj) {
    /* use the general-purpose contents lister to show a "wide" listing */
    listContGen(obj, &aDesc, 0, 0);
}

#pragma C-

#endif /* _LIST_CONT_T_ */
