////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: listFixedContCont() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _LIST_FIXED_CONT_CONT_T_
#define _LIST_FIXED_CONT_CONT_T_

#include <showcontcont.t>

#pragma C+

/*
 *  listFixedContCont: function(obj)
 *
 *  List the contents of the contents of any fixeditem objects
 *  in the contents list of the object obj.  This routine
 *  makes sure that all objects that can be taken are listed somewhere
 *  in a room's description.  This routine recurses down the contents
 *  tree, following each branch until either something has been listed
 *  or the branch ends without anything being listable.  This routine
 *  displays a complete sentence, so no introductory or closing text
 *  is needed.
 */
listFixedContCont: function(obj) {
    local list, i, tot, thisObj;

    list = obj.contents;
    tot = length(list);
    i = 1;
    while (i <= tot) {
        thisObj = list[i];
        if (thisObj.isFixed 
        && thisObj.canSenseContents(sight, nil) 
        && !thisObj.isQcontainer)
            showContCont(thisObj);
        i = i + 1;
    }
}

#pragma C-

#endif /* _LIST_FIXED_CONT_CONT_T_ */
