////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: scoreFormat() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _SCORE_FORMAT_T_
#define _SCORE_FORMAT_T_

#pragma C+

/*
 *  scoreFormat: function(points, turns)
 *
 *  This function returns the formatted display string to show in the right
 *  half of the status line, where the score and turn count are normally
 *  displayed.  If you wantd to display a different type of information in
 *  the right half of the status line, you can override this function to
 *  return the string you wish to display.
 */
scoreFormat: function(points, turns) {
    /* return a string with the standard points/turns display */
    return cvtstr(points) + '/' + cvtstr(turns);
}

#pragma C-

#endif /* _SCORE_FORMAT_T_ */
