////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: turnCount() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _TURN_COUNT_T_
#define _TURN_COUNT_T_

#include <clock.h>
#include <global.t>
#include <scorestatus.t>

#pragma C+

/*
 *  turnCount: function(parm)
 *
 *  This function can be used as a daemon (normally set up in the init
 *  function) to update the turn counter after each turn.  This routine
 *  increments global.turnSoFar, and then calls setscore to
 *  update the status line with the new turn count.
 */
turnCount: function(parm) {
    local str;
    
    // Set Phase and Stage
    global.setCommandPhase(CP_DAEMON);
    
    // Get any outcaptured display from exited action methods
    str = nestOutcapture(nil);
    say(str);
    incturn();
    global.turnSoFar = global.turnSoFar + 1;
	gameClock.advance( nil );
    scoreStatus(global.score, global.turnSoFar);
}

#pragma C-

#endif /* _TURN_COUNT_T_ */
