////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: DarkVerb 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _DARK_VERB_H_
#define _DARK_VERB_H_

#pragma C+

#include <deepverb.h>
#include <clock.h>
#include <gotosleep.t>
#include <global.t>

/*
 *  DarkVerb - a verb that can be used in the dark.  Travel verbs
 *  are all dark verbs, as are system verbs (quit, save, etc.).
 *  In addition, certain special verbs are usable in the dark:  for
 *  example, you can drop objects you are carrying, and you can turn
 *  on light sources you are carrying. 
 */
class DarkVerb: DeepVerb
   isDarkVerb = true
;

againVerb: DarkVerb         // Required verb:  repeats last command.  No
    verb = 'again' 'g'
;
dropVerb: DarkVerb
    verb = 'drop' 'put down'
    sDesc = "drop"
    ioAction(onPrep) = 'PutOn'
    doAction = 'Drop'
    doDefault(actor, prep, io) = {
        return actor.contents;
    }
;
sleepVerb: DarkVerb
    verb = 'sleep'
    sDesc = "sleep"
    action(actor) = {
        if (actor.cantSleep)
            "%You% %are% much too anxious worrying about %your% continued
            survival to fall asleep now. ";
        else if (global.awakeTime+1 < global.sleepTime)
            "%You're% not tired. ";
        else if (!(actor.location.isBed || actor.location.isChair))
            "I don't know about you, but I can never sleep
            standing up. %You% should find a nice comfortable
            bed somewhere. ";
        else {
            "%You% quickly drift%s% off into dreamland...\b";
            goToSleep();
        }
    }
;
turnOnVerb: DarkVerb
    verb = 'activate' 'turn on' 'switch on'
    sDesc = "turn on"
    doAction = 'Turnon'
;
waitVerb: DarkVerb
	verb = 'wait' 'waitfor' 'waituntil' 'z'
	sDesc = "wait"
	action( actor ) = {gameClock.wait; }
;

#pragma C-

#endif /* _DARK_VERB_H_ */
