/*  TADS code.  General functions file, version 1.0, by TenthStone.

    Requires an object named global.
*/

#pragma C+

choose : function;        // new
execute : function;       // new
gac : function;           // new
gacal : function;         // new
gacil : function;         // new
getIndexList : function;  // new
getOutput : function;     // new
imperative : function;    // new
inputLine : function;
listListing : function;   // new
listWithout : function;   // new
pac : function;           // new
_rand : function;
redirect : function;      // new
resource : function;      // new
sayDate : function;       // new
sayNumber : function;     // modified
sayValue : function;      // new
setHer : function;        // new
setHim : function;        // new
setThem : function;       // new
tabs : function;          // new

// chooses a value in a matrix according to a set of values.
//  I just find this sort of thing handy, instead of having
//  combinatoric switches.  The matrix must be as deep as
//  there exist switches.
choose: function( matr, ... ) {
    local c, cnt = argcount, swi;
    for (c = 2; c <= cnt; ++c) {
      swi = getarg( c );
      if (swi == true) swi = 1;
      else if (swi == nil) swi = 2;
//      else if (datatype( swi ) <> TYPE_NUMBER) {
//        "choose: invalid switch (<< sayValue( swi ) >>). ";
//        return nil;
//      }    // omitted for optimisation (runtime will catch this anyway)
      matr = matr[swi];
    }
    return matr;
}

// executes a command via execCommand, with defaults,
//  a more generous interface, and an option (nil|true)
//  to run fuses/daemons afterward.
execute: function( actor, verb, ... ) {
    local dobj, prep, iobj, ret, ct;
    local oa = global.curactor, ov = global.curverb;
    local od = global.curdobj, op = global.curprep;
    local oi = global.curiobj, ol = global.curaloc;
    switch (argcount) {
        case 6: ct = getarg( 6 );
        case 5: iobj = getarg( 5 );
                prep = getarg( 4 );
        case 3: dobj = getarg( 3 );
    }
    if (dobj == true) { dobj = nil; ct = true; }
    if (prep == true) { prep = nil; ct = true; }
    
    ret = execCommand( actor, verb, dobj, prep, iobj );
    if (ct) {
        runfuses();
        rundaemons();
    }
    global.curactor = oa; global.curverb = ov;
    global.curdobj = od; global.curprep = op;
    global.curiobj = oi; global.curaloc = ol;
    return ret;
}

// Get All (objects of) Class (everywhere)
//   Four arguments:  class, property, value, parameter
//  Only the first is required.  If property exists,
//  then that property on each object must be equal to
//  value (defaults to true) for it to be included.
//  Parameter will be passed to the property if supplied.
gac: function( cls, ... ) {
    local lst = [], o, prop, val = true, parm;
    switch (argcount) {
        case 4: parm = getarg( 4 );
        case 3: val = getarg( 3 );
        case 2: prop = getarg( 2 );
    }
    for (o = firstobj( cls ); o; o = nextobj( o, cls )) {
        if (prop) {
          if (argcount >= 4) {
            if (o.(prop)( parm ) == val) lst += o;
          }
          else if (o.(prop) == val) lst += o;
        }
        else lst += o;
    }
    return lst;
}

// Get All (of) Class In list
gacil: function( cls, lst, ... ) {
    local i, len = length( lst ), ret = [], prop, val = true, parm;
    switch (argcount) {
        case 5: parm = getarg( 5 );
        case 4: val = getarg( 4 );
        case 3: prop = getarg( 3 );
    }
    for (i = 1; i <= len; ++i) {
        if (isclass( lst[i], cls )) {
          if (prop) {
            if (argcount >= 4) {
              if (lst[i].(prop)( parm ) == val) ret += lst[i];
            }
            else if (lst[i].(prop) == val) ret += lst[i];
          }
          else ret += lst[i];
        }
    }
    return ret;
}

// Get All (of) Class Around (and including objects in) list
gacal: function( cls, lst, ... ) {
    local i, len = length( lst ), ret = [], prop, val = true, parm;
    switch (argcount) {
        case 5: parm = getarg( 5 );
        case 4: val = getarg( 4 );
        case 3: prop = getarg( 3 );
    }
    for (i = 1; i <= len; ++i) {
        if (isclass( lst[i], cls )) {
          if (prop) {
            if (argcount >= 5) {
              if (lst[i].(prop)( parm ) == val) ret += lst[i];
            }
            else if (lst[i].(prop) == val) ret += lst[i];
          }
          else ret += lst[i];
        }
        if (argcount >= 5) ret += lst[i].gacva( cls, prop, val, parm );
        else ret += lst[i].gacva( cls, prop, val );
    }
    return ret;
}

// returns a list of finds.
getIndexList: function( lst, val ) {
    local ret = [], i, len = length( lst );
    for (i = 1; i <= len; ++i) {
      if (lst[i] == val) ret += i;
    }
    if (ret == []) return nil;
    return ret;
}

// gets what is outputted by a function or method:
//  getOutput( object, property )
//  getOutput( function )
getOutput: function( ... ) {
    local obj, pnt, ret;
    switch (argcount) {
        case 1:
            pnt = getarg( 1 );
            ret = outcapture( true );
            (pnt);
            return outcapture( ret );
        case 2:
            pnt = getarg( 2 );
            obj = getarg( 1 );
            ret = outcapture( true );
            obj.(pnt);
            return outcapture( ret );
    }
}

//  The imperative operator, found in BASIC among others.  Only
//  consider the second value if the first is true;  otherwise, it's true.
//  Used in .isvisiblyin:  only consider position if a second argument exists.
//  Used by doorway :  only consider .mykeyKnown if mykey exists.
imperative: function( a, b ) {
    if (a) a = true; else a = nil;
    if (b) b = true; else b = nil;
    if (a) return b;
    return true;
}

// stolen from ADV.T.  Just like input(), except changes the
//  font to the interpreter's input font (changing the value
//  in the interpreter's options sets the global font variable
//  'TADS-Input').
inputLine: function {
    local ret, HTML_mode = (systemInfo(__SYSINFO_SYSINFO) == true and systemInfo(__SYSINFO_HTML_MODE));
    if (HTML_mode) "<font face='TADS-Input'>";
    ret = input();
    if (HTML_mode) "</font>";
    return ret;
}

// lists the contents of a list (using .thedesc).
listListing: function( lst ) {
    local len = length( lst ), i;
    for (i = 1; i <= len; ++i) {
      lst[i].thedesc;
      if (i < len - 1) " and ";
      else if (i < len) ", ";
    }
    return len;
}

// returns a list with the given value taken out.
listWithout: function( lst, n ) {
    local ret = [], i;
    for (i = 1; i < n; ++i) {
      ret += car[ lst ];
      lst = cdr[ lst ];
    }
    ret += cdr[ lst ];
    return ret;
}

// prompt (for a keypress) and clear (the screen)
pac: function {
    morePrompt();
    clearscreen();
}

// fixes an error with the randomizer.  Taken from bugs.t.
_rand: function( n ) {
    return (((rand(16 * n) - 1) / 16) + 1);
}

// like execute, except it changes the current command
//  instead of simply executing a different one.
redirect: function( actor, verb, ... ) {
    local dobj, prep, iobj;
    switch (argcount) {
        case 5:
            iobj = getarg( 5 );
            prep = getarg( 4 );
        case 3:
            dobj = getarg( 3 );
    }
    return execCommand( actor, verb, dobj, prep, iobj );    
}

// uses a given resource (single-quoted resource name) with (optional)
//  the given options (single-quoted string of appropriate HTML tag
//  properties).  Giving 'nil' as the resource cancels all sound.
resource: function( rsc, ... ) {
    local len, typ = '', opts, i;
    if (not global.hasHTML) return true;
    if (rsc == nil) "<sound cancel>";
    len = length( rsc );
    for (i = len; i >= 1; --i) {
      if (substr( rsc, i, 1 ) == '.') {
        typ = lower( substr( rsc, i + 1, len - i ) );
        break;
      }
    }
    if (argcount >= 2) opts = getarg( 2 );
    switch( typ ) {
      case 'jpg': case 'jpeg':
        if (systemInfo( __SYSINFO_JPEG ) == 0 or systemInfo( __SYSINFO_PREF_IMAGES ) == 0) return true;
        "<img src='<< rsc >>' << opts >>>"; return nil;
      case 'png':
        if (systemInfo( __SYSINFO_PNG ) == 0 or systemInfo( __SYSINFO_PREF_IMAGES ) == 0) return true;
        "<img src='<< rsc >>' << opts >>>"; return nil;
      case 'wav':
        if (systemInfo( __SYSINFO_WAV ) == 0 or systemInfo( __SYSINFO_PREF_SOUNDS ) == 0) return true;
        "<sound src='<< rsc >>' << opts >>>"; return nil;
      case 'mid': case 'midi':
        if (systemInfo( __SYSINFO_MIDI ) == 0 or systemInfo( __SYSINFO_PREF_MUSIC ) == 0) return true;
        "<sound src='<< rsc >>' << opts >>>"; return nil;
      case 'mpg':
        if (systemInfo( __SYSINFO_MPEG_AUDIO_1 ) == 0) return true;
        "<sound src='<< rsc >>' << opts >>>"; return nil;
      case 'mp2':
        if (systemInfo( __SYSINFO_MPEG_AUDIO_2 ) == 0) return true;
        "<sound src='<< rsc >>' << opts >>>"; return nil;
      case 'mp3':
        if (systemInfo( __SYSINFO_MPEG_AUDIO_3 ) == 0) return true;
        "<sound src='<< rsc >>' << opts >>>"; return nil;
      default:
        return true;
    }
}
      
// takes the TADS compressed date standard and outputs
//  a readable date.
sayDate: function( ds ) {
    switch (substr( ds, 1, 3 )) {
        case 'Jan': "January"; break;   case 'Feb': "February"; break;
        case 'Mar': "March"; break;     case 'Apr': "April"; break;
        case 'May': "May"; break;       case 'Jun': "June"; break;
        case 'Jul': "July"; break;      case 'Aug': "August"; break;
        case 'Sep': "September"; break; case 'Oct': "October"; break;
        case 'Nov': "November"; break;  case 'Dec': "December"; break;
        default: say( substr( ds, 1, 3 ) );
    }
    " << cvtnum( substr( ds, 5, 2 ) ) >>, << substr( ds, 8, 4 ) >>. ";
}

// says a number in words, e.g. 'forty-two'.
sayNumber: function( cnt ) {
    if (cnt < 0) {
        cnt = -cnt;
        if (cnt > 100) "-";
        else "negative";
    }
    if (cnt > 100) say( cnt );
	//  If there are 101 identical objects in this game, screw it.
    else if (cnt == 100) "one hundred";
    else if (cnt == 0) "zero";
    else {
      local o = [ 'one' 'two' 'three' 'four' 'five' 'six' 'seven' 'eight'
	  'nine' ],
	t = [ 'ten' 'twenty' 'thirty' 'forty' 'fifty' 'sixty' 'seventy'
	  'eighty' 'ninety' ],
	s = [ 'eleven' 'twelve' 'thirteen' 'fourteen' 'fifteen'
	  'sixteen' 'seventeen' 'eighteen' 'nineteen' ];
      if (cnt < 10) say( o[cnt] );
      else if (cnt % 10 == 0) say( t[cnt / 10] );
      else if (cnt < 20) say( s[cnt - 10] );
      else {
	say( t[cnt / 10] ); "-"; say( o[cnt % 10] );
      }
    }
}

// say the value given, no matter whether function or what.
sayValue: function( val ) {
    local i, len;
    switch (datatype( val )) {
      case TYPE_DOUBLE: "(double-quoted string)"; break;
      case TYPE_FUNCTION: "(function pointer)"; break;
      case TYPE_LIST:
        "[";
        for (i = 1, len = length( val ); i <= len; ++i) {
          sayValue( val[i] );
          if (i <> len) " ";
        }
        "]";
        break;
      case TYPE_NIL: "nil"; break;
      case TYPE_NUMBER: "<< val >>"; break;
      case TYPE_OBJECT: "(object: <b><< val.sdesc >></b>)"; break;
      case TYPE_PROPERTY: "(property pointer)"; break;
      case TYPE_SINGLE: "'<< val >>'"; break;
      case TYPE_TRUE: "true"; break;
    }
}

// set the "her" pronoun to obj.
setHer: function( obj ) {
    setit( obj, 2 );
}

// set the "him" pronoun to obj.
setHim: function( obj ) {
    setit( obj, 1 );
}

// set the "them" pronoun to obj/list.
setThem: function( obj ) {
    if (obj == nil) setit( nil );
    else if (datatype( obj ) == TYPE_LIST) setit( obj );
    else setit( [ obj ] );
}

// returns a sublist, like substr returns a substring.
//  T3 includes this function by default.  The analogy
//  to substr causes the non-standard capitalisation.
sublist: function( lst, start, ... ) {
    local ret = [], end = length( lst );
    if (argcount >= 3) end = getarg( 3 );
    for (; start <= end; ++start) ret += lst[start];
    return ret;
}
    
// prints the specified number of tabs (or, optionally,
//  any string passed as the second argument).
tabs: function( num, ... ) {
    local str = '\t';
    if (argcount >= 2) str = getarg( 2 );
    for (;num > 0; num--) "<< str >>";
}
