#pragma C-

#include <pianosa.t>
#include <ts_menu.t>

addfootnote : function;    // here
commandAfterRead : function;
commandPrompt : function;
conclude : function;
die : function;
init : function;
initCommon : function;
initRestart : function;
modifyParseError : function;
pardon : function;
rank : function;
specialPreinit : function;
stumble : function;
terminate : function;

commence : function;       // gamefile

/* * * Functions * * */
addfootnote: function( msg ) {
    local l := length( global.footnotelist ) + 1;
    global.footnotelist += msg;
    if (global.hasHTML) "<sup><a href='Footnote << l >>'><< l >></a></sup>";
    else " (<< l >>)";
}

commandPrompt: function( p ) {
    "\b&gt;<font face='TADS-Input'>";
}

commandAfterRead: function( p ) {
    "</font>";
}

conclude: function {
    terminate();
    "<sound cancel>";
    quit();
}

die: function( ... ) {
    local str := 'You have died.';
    if (argcount > 0) str := getarg( 1 );
    "\b\t\t\(<< str >>\)\n";
    writeMenu( endMenu, 1 );
}

init: function {
    "\H+";                      // always enable HTML markups.  Makes it easier
    Me.becomeMe;
    initCommon();
    commence();
    "\b";
    parserGetMe().startAt;
}

initCommon: function {
    initLibrary();
    setDaemon( hungerDaemon, nil );
    setDaemon( sleepDaemon, nil );
    "<title><< version.sdesc >></title>
    <AboutBox><< version.ldesc >></AboutBox>";
}

initRestart: function( parm ) {
    global.restarting := true;
    clearscreen();
}

modifyParseError: function( err, str, ... ) {
    return nil;
}

pardon: function {
    "The sound of silence echoes in << parserGetMe().fmtYour >> ears. ";
}

//  This is a general but mundane enough functionality that it's given here.
rank: function {
    "The score is << global.score >>";
    if (global.maxScore = global.minScore) ". ";
    else {
        local p := (global.score - global.minScore) * 100 / (global.maxScore - global.minScore);
        if (global.minScore <> 0) " as it ranges from << global.minScore >> to";
        else " out of";
        " << global.maxScore >>, or << sayNumber( p ) >> percent. ";
    }
}

specialPreinit: function {}

stumble: function {
    "Darkness surrounds you. ";
}

terminate: function {
    "\b\t\t Fin. ";
}


/* * * Objects * * */
// global is the official "options" object.
// .sleepyTime is how long (by default) the actors have been without food when hunger becomes
//  a factor.
// .curactor is the current actor (set in roomAction).
// .daemonlist is the list-of-lists of daemons.
// .daemonlistcount is the number of lists in daemonlist.
// .footnotelist is the list of footnotes, sq-strings.
// .hungerTime is the default time spent between the actor's fatal hunger pangs; an actor-specific
//  value can be set on an actor.
// .hungryTime is .sleepyTime with sleep (previously .lastMealTime).
// .restarting specifies whether the game has been restarted or not.
// .floatinglist is the list of floating objects in the game.
// .initRestartParam is the value passed as a parameter to initRestart.
// .inventall specifies whether inventory listings are tall or wide.
// .jostleJump is the default jostle level for an actor jumping.
// .jostlePutInto is the default jostle level for .putInto.
// .jostleThrow is the default jostle level for throwing an object.
// .lamplist is the list of portable lightsources in the game.  A lightsource is an object
//  with .islamp set to true (at the preinit stage).
// .maxScore is displayed by rank() next to the current score.
// .minScore is displayed by rank() (when nonzero) and is the initial
//   value for score.  When .maxScore = .minScore, .neither is
//   displayed.
// .Misunderstand is displayed when an input makes no sense.
// .positionlist is a list of all the position objects in the game,
//  ordered by their .position properties.
// .score is the current score.
// .Score is displayed when the score changes (or doesn't change).
// .sleepDuration is the actual time spent sleeping.
// .sleepTime is the default time spent between sleeping fits.
// .thisturn is the current turn.
// .verbose defines whether the game is in verbose mode or terse (true/nil).
// .verboseLook specifies whether the "verbose" command should execute an implicit
//  "look around."
// .verboseScore specifies whether global.Score should display anything or not.
global: object
    Misunderstand = "That is not understood. "
    Score( n ) = {
        if (global.verboseScore) {
            "(your score has ";
            if (n > 0) "increased by << sayNumber( n ) >> point<< n < 1 ? "s" : "" >>";
            if (n = 0) "remained the same";
            if (n < 0) "decreased by << sayNumber( -n ) >> point<< n < -1 ? "s" : "" >>";
            ")\b";
        }
    }
    hungerTime = 200
    inventall = nil
    sleepTime = 400
    sleepDuration = 50
    maxScore = 100
    minScore = 0
    verboseLook = nil
    verboseScore = true
    verbose = true

    daemonlist = []
    daemonlistcount = 5
    directionlist = []
    exitlist = []
    floatinglist = []
    footnotelist = []
    hungryTime = 0
    initRestartParam = nil
    lamplist = []
    positionlist = []
    restarting = nil
    score = (global.minScore)
    sleepyTime = 0
    thisturn = 0

    curaloc = nil
    curverb = nil
    curdobj = nil
    curprep = nil
    curiobj = nil
    curactor = nil

    hasHTML = (systemInfo( __SYSINFO_SYSINFO ) ? systemInfo( __SYSINFO_HTML_MODE ) : nil)
    hasMusic = (hasHTML ? systemInfo( __SYSINFO_PREF_MUSIC ) = 1 : nil)
    hasAmbient = (hasHTML ? systemInfo( __SYSINFO_PREF_SOUNDS ) = 1 : nil)
    hasBGAmbient = (hasHTML ? systemInfo( __SYSINFO_PREF_SOUNDS ) = 1 : nil)

    jostleJump = 2
    jostlePutInto = 1
    jostleThrow = 2
;

Me: basicMe, notified
    startAt = (self.travelTo( startroom ))
;

modify numObj
    verDoFootnote( a ) = {
        if (self.value > length( global.footnotelist )) "Not such footnote exists. ";
    }
    doFootnote( a ) = {
        say( global.footnotelist[self.value] );
        abort;
    }
;


/* * * Verbs * * */
footnoteVerb: sysVerb
    verb = 'footnote'
    sdesc = "footnote"
    Help = "Read the text for footnote n. "
    validDo( a, o, i ) = (o = numObj)
    doAction = 'Footnote'
    value = 8
    action( a ) = {
      local n := length( global.footnotelist );
      "There << n = 1 ? 'is' : 'are' >> << sayNumber( n ) >> footnote<<
      n = 1 ? '' : 's' >> available. ";
    }
;

dVerb: travelVerb
    dirGoDirProp = &goDown
    dirNames = [ 'down' 'd' ]
    dirTravel = &down
    verb = 'd' 'down' 'go down'
;

eVerb: travelVerb
    dirGoDirProp = &goEast
    dirNames = [ 'east' 'e' ]
    dirTravel = &east
    verb = 'e' 'east' 'go east' // 'move east'
;

inVerb: travelVerb
    dirGoDirProp = &goEnter
    dirNames = [ 'enter' 'in' ]
    dirTravel = &enter
    verb = 'in' 'go in' 'enter' // 'move in'
    sdesc = "enter"
    validInDark( a, d, p, i ) = (d = nil)
    doAction = 'Enter'
    ioAction(onPrep) = 'EnterOn'
    ioAction(inPrep) = 'EnterIn'
    ioAction(withPrep) = 'EnterWith'
    doIsTouched( p ) = (p = nil)
    ioIsTouched( p ) = true
;

nVerb: travelVerb
    dirGoDirProp = &goNorth
    dirNames = [ 'north' 'n' ]
    dirTravel = &north
    verb = 'n' 'north' 'go north' // 'move north'
;

neVerb: travelVerb
    dirGoDirProp = &goNE
    dirNames = [ 'northeast' 'ne' ]
    dirTravel = &ne
    verb = 'ne' 'northeast' 'go ne' 'go northeast' // 'move northeast' 'move ne'
;

nwVerb: travelVerb
    dirGoDirProp = &goNW
    dirNames = [ 'northwest' 'nw' ]
    dirTravel = &nw
    verb = 'nw' 'northwest' 'go nw' 'go northwest' // 'move northwest' 'move nw'
;

outVerb: travelVerb
    dirGoDirProp = &goOut
    dirNames = [ 'out' 'exit' ]
    dirTravel = &out
    verb = 'out' 'go out' 'exit' 'leave' 'move out'
;

sVerb: travelVerb
    dirGoDirProp = &goSouth
    dirNames = [ 'south' 's' ]
    dirTravel = &south
    verb = 's' 'south' 'go south' // 'move south'
;

seVerb: travelVerb
    dirGoDirProp = &goSE
    dirNames = [ 'southeast' 'se' ]
    dirTravel = &se
    verb = 'se' 'southeast' 'go se' 'go southeast' // 'move southeast' 'move se'
;

swVerb: travelVerb
    dirGoDirProp = &goSW
    dirNames = [ 'southwest' 'sw' ]
    dirTravel = &sw
    verb = 'sw' 'southwest' 'go sw' 'go southwest' // 'move southwest' 'move sw'
;

uVerb: travelVerb
    dirGoDirProp = &goUp
    dirNames = [ 'up' 'u' ]
    dirTravel = &up
    verb = 'u' 'up' 'go up'
;

wVerb: travelVerb
    dirGoDirProp = &goWest
    dirNames = [ 'west' 'w' ]
    dirTravel = &west
    verb = 'w' 'west' 'go west' // 'move west'
;


/* * * Menus * * */
class quitMenu: Menu
    menuClear = nil
    menuTitle = "Quit"
    menuKeyed = nil
    orderMenu( lst, lvl, parm ) = {
        lst -= qMReturn;
        return lst + qMReturn;
    }
;

qMQuit: quitMenu
    menuDesc = "\(Q\)uit << version.sdesc >>"
    menuKeys = [ 'q' 'quit' ]
    menuAction( cls, lvl, parm ) = {
        conclude();
    }
;

qMReturn: quitMenu
    menuDesc = "\(R\)eturn"
    menuKeys = [ 'r' 'return' ]
    menuAction( cls, lvl, parm ) = 1
;


class optionsMenu: Menu
    menuTitle = "Options"
;

optionsMenuDisplay: optionsMenu
    menuAction( cls, lvl, parm ) = {
        return writeMenu( displayMenu, 2 );
    }
    menuDesc = "\(D\)isplay options"
    menuKeys = [ 'display' 'd' 'display options' ]
;

optionsMenuSound: optionsMenu
    menuAction( cls, lvl, parm ) = {
        return writeMenu( soundMenu, 2 );
    }
    menuDesc = "\(S\)ound options"
    menuKeys = [ 'sound' 's' 'sound options' ]
;


class displayMenu: Menu
    menuTitle = "Display"
;

displayMenuInventory: displayMenu
    menuAction( cls, lvl, parm ) = {
        global.inventall := not global.inventall;
    }
    menuDesc = (global.inventall ? "\(I\)nventory wide" : "\(I\)nventory tall" )
    menuKeys = [ 'i' 'inventory' 'inventory tall' 'inventory wide' 'itall' 'iwide' ]
;
        

class soundMenu: Menu
    menuTitle = "Sound"
;

soundMenuMusic: soundMenu
    menuAction( cls, lvl, parm ) = {
        if (global.hasMusic) {
            "<sound cancel=background>";
            global.hasMusic := nil;
        }
        else {
            global.hasMusic := (global.hasHTML ? systemInfo( __SYSINFO_PREF_MUSIC ) = 1 : nil);
            if (global.hasMusic) parserGetMe().locate.initMusic;
        }
    }
    menuDesc = (global.hasMusic ? "Turn off \(m\)usic" : "Turn on \(m\)usic")
    menuKeys = [ 'music' 'm' ]
;

soundMenuAmbient: soundMenu
    menuAction( cls, lvl, parm ) = {
        if (global.hasAmbient) {
            "<sound cancel=ambient>";
            global.hasAmbient := nil;
        }
        else {
            global.hasAmbient := (global.hasHTML ? systemInfo( __SYSINFO_PREF_SOUNDS ) = 1 : nil);
            if (global.hasAmbient) parserGetMe().locate.initAmbient;
        }
    }
    menuDesc = (global.hasAmbient ? "Turn off \(a\)mbient sounds" : "Turn on \(a\)mbient sounds")
    menuKeys = [ 'a' 'ambient'  'ambient sounds' ]
;

soundMenuBGAmbient: soundMenu
    menuAction( cls, lvl, parm ) = {
        if (global.hasBGAmbient) {
            "<sound cancel=bgambient>";
            global.hasBGAmbient := nil;
        }
        else {
            global.hasBGAmbient := (global.hasHTML ? systemInfo( __SYSINFO_PREF_SOUNDS ) = 1 : nil);
            if (global.hasBGAmbient) parserGetMe().locate.initBGAmbient;
        }
    }
    menuDesc = (global.hasBGAmbient ? "Turn off back\(g\)round ambient sounds" : "Turn on \(b\)ackground ambient sounds")
    menuKeys = [ 'g' 'background' 'bg' 'background ambient'  'background ambient sounds' ]
;


class restartMenu: Menu
    menuClear = nil
    menuTitle = "Restart"
    orderMenu( lst, lvl, parm ) = { return lst; }
;

restartMenuYes: restartMenu
    menuAction( cls, lvl, parm ) = {
    	"\n";
        showScore(0, 0);
        restart( initRestart, global.initRestartParam );
    }
    menuDesc = "\(Y\)es"
    menuKeys = [ 'y' 'yes' ]
;

restartMenuNo: restartMenu
    menuAction( cls, lvl, parm ) = ("\nOkay.\n", 1)
    menuDesc = "\(N\)o"
    menuKeys = [ 'n' 'no' ]
;

class endMenu: Menu
    menuClear = nil
    menuTitle = ""
    menuKeyed = nil
    orderMenu( lst, lvl, parm ) = { return (lst); }
;

endMenuUndo: endMenu
    menuAction( cls, lvl, parm ) = (undoVerb.verbtask( parserGetMe() ))
    menuDesc = "\(U\)ndo"
    menuKeys = [ 'undo' 'u' 'back' ]
;

//  If quitVerb.verbtask returns at all, stay in menu.
endMenuQuit: endMenu
    menuAction( cls, lvl, parm ) = (writeMenu( quitMenu, lvl + 1 ))
    menuDesc = "\(Q\)uit"
    menuKeys = [ 'exit' 'x' 'quit' 'q' ]
;

endMenuRestore: endMenu
    menuAction( cls, lvl, parm ) = (restoreVerb.verbtask( parserGetMe() ))
    menuDesc = "\(R\)estore"
    menuKeys = [ 'restore' 'r' 'load' 'l' ]
;

endMenuRestart: endMenu
    menuAction( cls, lvl, parm ) = (restart( initRestart, global.initRestartParam ))
    menuDesc = "\(N\)ew"
    menuKeys = [ 'restart' 's' 'new' 'n' ]
;
