//
//  XTAbout.m
//  XTads
//
//  Created by Rune Berg on 31/10/15.
//  Copyright © 2015 Rune Berg. All rights reserved.
//

#import "trd.h"
#import "vmvsn.h"
#import "XTAbout.h"


@implementation XTAbout

static XTAbout *singletonInstance = nil;

+ (void)initialize
{
	if (singletonInstance != nil) {
		// we can be called more than once :-(
		return;
	}
	singletonInstance = [XTAbout new];
}

+ (id)about
{
	return singletonInstance;
}

- (instancetype)init
{
	self = [super init];
	if (self != nil) {
		_thankYouText = [NSMutableAttributedString new];
		[self appendToThankYouText:@"Mike, for TADS, and for patiently answering many questions.\n"];
		[self appendToThankYouText:@"Petter Sjölund, for reporting a fatal bug.\n"];
		_xtadsVersion = [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleShortVersionString"];
		_tads2VmVersion = [NSString stringWithUTF8String:TADS_RUNTIME_VERSION];
		NSString *t3Ver = [NSString stringWithUTF8String:T3VM_VSN_STRING];
		NSString *t3Ident = [NSString stringWithUTF8String:T3VM_IDENTIFICATION];
		_tads3VmVersion = [NSString stringWithFormat:@"%@ (%@)", t3Ver, t3Ident];
		_licenseText = [[NSAttributedString alloc] initWithString:internalLicenseText];
		_terpAuthorName = @"Rune Berg";
		_terpAuthorEmailAddress = @"runeberg76@gmail.com";
		_terpHomepageLinkText = @"https://xtadsetc.com";
		_terpHomepageUrl = @"https://xtadsetc.com";
		_tadsHomepageLinkText = @"http://www.tads.org";
		_tadsHomepageUrl = @"http://www.tads.org";
	}
	return self;
}

- (void)appendToThankYouText:(NSString *)string
{
	NSMutableAttributedString *tempThankYouText = [[NSMutableAttributedString alloc] initWithAttributedString:self.thankYouText];
	NSAttributedString * toAppend = [[NSAttributedString alloc] initWithString:string];
	[tempThankYouText appendAttributedString:toAppend];
	self.thankYouText = tempThankYouText;
}

static NSString *internalLicenseText =
@"\nHTML TADS FREEWARE SOURCE CODE LICENSE\n"
"\n"
"The HTML TADS source code is Copyright 1997, 2003 by Michael J. Roberts.\n"
"\n"
"The author hereby grants you permission to use, copy, and "
"distribute this software, if you agree to the following conditions:\n"
"\n"
"    1. You must include this license and the copyright notice with "
"all copies.\n"
"    2. You may not require or collect a fee for copies of this "
"software, or any part of this software, that you give to "
"other people.\n"
"    3. You may not include this software with any other software "
"for which a fee is collected.\n"
"    4. You may not modify this software except as permitted below "
"(see \"derivative works\"), and each copy you make and "
"distribute must be a full and complete copy of the software "
"you originally received.\n"
"    5. Anyone to whom you give a copy of this software receives "
"all of the same permissions that you did under this license "
"and is subject to all of the same restrictions.\n"
"    6. You are not allowed to create derivative works, which are "
"works that contain or are based on all or part of this work, "
"except under the conditions described below.\n"
"    7. Any derivative works are subject to this same license.\n"
"\n"
"\n"
"Derivative Works\n"
"------------------------\n"
"\n"
"This source code is distributed for the specific purpose of "
"facilitating the creation of versions of TADS on various computers and "
"operating systems.  All other derivative works are prohibited without "
"the written permission of the author.  Please contact the author if "
"you have any questions about this or if you'd like permission to "
"create a derived work.\n"
"\n"
"If you port TADS to a new platform, the author does grant permission "
"for you to distribute your ported version - I encourage it, in fact. "
"We ask that you provide your contact information in any distribution "
"package you create, so that users of your version will know how to "
"contact you if they have any questions relating specifically to your "
"version.\n";

@end
