//
//  XTHtmlTagTab.m
//  TadsTerp
//
//  Created by Rune Berg on 05/04/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTHtmlTagTab.h"
#import "XTBaseTextHandler.h"
#import "XTAllocDeallocCounter.h"


@implementation XTHtmlTagTab

OVERRIDE_ALLOC_FOR_COUNTER
OVERRIDE_DEALLOC_FOR_COUNTER

#define XT_ALIGN_ATTR_NAME @"align"
#define XT_ID_ATTR_NAME @"id"
#define XT_ALIGN_ATTR_VALUE_RIGHT @"right"

+ (NSString *)name
{
	return @"tab";
}

+ (BOOL)standalone
{
	return YES;
}

- (void)format:(NSObject<XTOutputFormatterProtocol> *)formatter
   textHandler:(XTBaseTextHandler *)textHandler;
{
	NSArray *formattedElements = [formatter handleHtmlTagTab:self];
	[textHandler receiveFormattedElements:formattedElements];
}

+ (instancetype)rightAligned
{
	XTHtmlTagTab *tabTag = [XTHtmlTagTab new];
	[tabTag addAttribute:XT_ALIGN_ATTR_NAME value:XT_ALIGN_ATTR_VALUE_RIGHT];
	return tabTag;
}

+ (instancetype)forPlainTextMode
{
	XTHtmlTagTab *tabTag = [XTHtmlTagTab new];
	[tabTag addAttribute:@"multiple" value:@"4"];
	return tabTag;
}

- (BOOL)isRightAligned
{
	NSString *align = [self attributeAsString:XT_ALIGN_ATTR_NAME];
	BOOL res = (align != nil && [align isEqualToString:XT_ALIGN_ATTR_VALUE_RIGHT]);
	return res;
}

- (BOOL)isForId
{
	NSString *id = [self attributeAsString:XT_ID_ATTR_NAME];
	BOOL res = (id != nil);
	return res;
}

@end
