//
//  XTOutputTextParserProtocol.h
//  TadsTerp
//
//  Created by Rune Berg on 28/04/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>

@class XTHtmlTag;
@class XTHtmlTagContainer;


@protocol XTOutputTextParserProtocol <NSObject>

- (void)resetForNextCommand;

- (void)parse:(NSString *)string;

- (XTHtmlTagContainer *)getOuterContainer;

- (void)appendTagToCurrentContainer:(XTHtmlTag *)tag;

- (void)pushContainer:(XTHtmlTagContainer *)container;

- (void)endNormalTag:(XTHtmlTag *)tag;

- (void)flush;

- (void)hardFlush;

- (void)teardown;

@end
