//
//  XTPrefsGroup.m
//  XTads
//
//  Created by Rune Berg on 19/04/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import "XTPrefsGroup.h"
#import "XTPrefsItem.h"


@interface XTPrefsGroup ()

@property NSMutableArray<XTPrefsItem *> *itemArray;

@end


@implementation XTPrefsGroup

- (id)init
{
	self = [super init];
	if (self != nil) {
		_itemArray = [NSMutableArray arrayWithCapacity:25];
	}
	return self;
}

- (void)add:(XTPrefsItem *)item
{
	[self.itemArray addObject:item];
}

- (void)restoreFromPersisted
{
	for (XTPrefsItem *item in self.itemArray) {
		[item restoreFromPersisted];
	}
}

- (void)persist
{
	for (XTPrefsItem *item in self.itemArray) {
		[item persist];
	}
}

- (void)addObserver:(NSObject *)observer
{
	for (XTPrefsItem *item in self.itemArray) {
		[item addObserver:observer];
	}
}

- (void)removeObserver:(NSObject *)observer
{
	for (XTPrefsItem *item in self.itemArray) {
		[item removeObserver:observer];
	}
}

- (void)resetToDefaultValues
{
	for (XTPrefsItem *item in self.itemArray) {
		[item resetToDefaultValue];
	}
}

@end
