//
//  XTOutputTextHandler.h
//  TadsTerp
//
//  Created by Rune Berg on 28/03/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
//#import "XTGameWindowController.h"
#import "XTCommandHistory.h"
#import "XTOutputTextView.h"
#import "XTGameWindowController.h"


@interface XTOutputTextHandler : NSObject

@property (weak) XTGameWindowController *gameWindowController;

@property NSMutableString *gameTitle;

@property (weak) NSScrollView *outputTextScrollView;
@property (unsafe_unretained) XTOutputTextView *outputTextView;

@property XTCommandHistory *commandHistory;
@property NSUInteger commandPromptPosition;
@property BOOL htmlMode;
@property BOOL nonstopMode;
@property BOOL paginationActive;
@property void *activeTagBannerHandle;
@property BOOL statusLineMode;

+ (instancetype)handler;

- (void)removeHandler;

- (void)setHiliteMode:(BOOL)hiliteMode;

- (void)setIsForT3:(BOOL)isForT3;

- (void)resetToDefaults;

- (void)resetForNextCommand;

- (void)resetForGameHasEndedMsg;

- (BOOL)appendOutput:(NSString *)string;

- (BOOL)pumpOutput;

- (void)flushOutput;

- (void)hardFlushOutput;

- (void)appendInput:(NSString *)string;

- (void)handleCommandLinkClicked:(NSString *)linkString atIndex:(NSUInteger)charIndex;

- (void)ensureInputFontIsInEffect;

- (void)clearText;

- (NSString *)getCommand;

- (void)mainThread_noteStartOfLayoutOfViews;

- (void)mainThread_noteEndOfLayoutOfViews;

- (void)noteStartOfPagination;

// the index where new output text should be appended
- (NSUInteger)endOfOutputPosition;

- (void)moveCursorToEndOfOutputPosition;

- (void)scrollToBottom;

// the index where new input text is appended
- (NSInteger)insertionPoint;

- (NSInteger)minInsertionPoint;

- (void)replaceCommandText:(NSString *)newCommandText;

- (BOOL)allowTextInsertion:(NSRange)affectedCharRange;

- (void)goToPreviousCommand;

- (void)goToNextCommand;

@end
