//
//  XTStringUtils.h
//  TadsTerp
//
//  Created by Rune Berg on 24/04/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>


#define ZERO_WIDTH_SPACE @"\u200B"
#define UNICHAR_EN_SPACE @"\u2002"


@interface XTStringUtils : NSObject

+ (BOOL)string:(NSString *)string endsWithChar:(unichar)ch;

+ (BOOL)string:(NSString *)string endsWith:(NSString *)end;

+ (BOOL)string:(NSString *)string endsWithCaseInsensitive:(NSString *)end;

+ (BOOL)string:(NSString *)string startsWith:(NSString *)start;

+ (BOOL)string:(NSString *)string1 isEqualToCaseInsensitive:(NSString *)string2;

+ (NSString *)filterRepeatedNewlines:(NSString *)string;

+ (NSRange)findRangeOfTrailingWhitespaceInLastParagraph:(NSString *)string;

+ (NSRange)findRangeOfLastParagraph:(NSString *)string;

+ (NSString *)trimLeadingAndTrailingWhitespace:(NSString *)string;

+ (NSString *)emptyIfNull:(NSString *)string;

+ (BOOL)isEmptyOrNull:(NSString *)string;

+ (BOOL)isInternetLink:(NSString *)string;

+ (NSString *)stringOf:(NSUInteger)n string:(NSString *)s;

+ (NSCharacterSet *)breakingWhitespaceCharSet;

+ (NSUInteger)indexInString:(NSString *)string ofCharAtRow:(NSUInteger)row column:(NSUInteger)column;

+ (NSRange)rangeOfLongestLineIn:(NSString *)string;

+ (unichar)removeLastCharFrom:(NSMutableString *)string;

+ (NSString *)numericPrefix:(NSString *)string;

+ (unichar)lastChar:(NSString *)string;

+ (NSArray *)splitString:(NSString *)s
			 bySeparator:(NSString *)sep
 includeSeparatorEntries:(BOOL)includeSepEntries;

+ (NSRange)rangeOfNextParagraphIn:(NSString *)string fromLoc:(NSUInteger)loc;

+ (NSArray *)splitAttributedString:(NSAttributedString *)attrString
					   bySeparator:(NSString *)separator;

@end
