#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>

/*

Path Finder test

Steve Breslin, 2004
steve.breslin@gmail.com

All of our path finder classes are set up so that you can call
<pathFinder>.findPath(fromNode, toNode) to get a path from the fromNode
to the toNode. The path is returned as a Vector, beginning with the
fromNode and ending with the toNode. If you just want to know the
distance, you can call <pathFinder>.findDistance(fromNode, toNode).

In the following tests (all involving "map crawling"), we also need
to pass the "actor" as an argument to these methods, since the path may
depend on which actor is traversing the map.

These tests rely on the search algorithms we set up in RmPthFnd.t --
take a look at that file if you haven't already.

The 'test' verb is designed to demonstrate how all this works.

*/

// we're using a random room graph for this demonstration.
// the FROMNODE and TONODE are the first and last rooms created.
#define FROMNODE roomGenerator.roomsVector[1]
#define TONODE roomGenerator.roomsVector[30] 

// again, to find a distance from, for example, DRPF, simply do:
// DRPF.findDistance(me, <start room>, <target room>)

// also, to find the path, simply do:
// DRPF.findPath(me, <start room>, <target room>)

VerbRule(TestVerb) 'test' : IAction
    execAction() {
        local pathFound;
        "Floyd:\n";
        "distance: <<(pathFound = roomPathFloyd.findDistance(FROMNODE, TONODE))>>\n";
        if (pathFound)
            "path: <<printPath(roomPathFloyd.findPath(FROMNODE, TONODE))>>\b";
        "Dijkstra:\n";
        "distance: <<pathFound = DRPF.findDistance(me, FROMNODE, TONODE)>>\n";
        if (pathFound)
            "<<printPath(DRPF.findPath(gPlayerChar, FROMNODE, TONODE))>>\b";
        "Breadth-First:\n";
        if(pathFound = BFRPF.findPath(gPlayerChar, FROMNODE, TONODE)) {
            "distance: <<BFRPF.findDistance(gPlayerChar, FROMNODE, TONODE)>>\n";
            "path: <<printPath(pathFound)>>\b";
        }
        "DoubleBreadth:\n";
        if(pathFound = DBRPF.findPath(gPlayerChar, FROMNODE, TONODE)) {
            "distance: <<DBRPF.findDistance(gPlayerChar, FROMNODE, TONODE)>>\n";
            "path: <<printPath(pathFound)>>\n";
        }
    }
    printPath(vec) {
        local ret = '';
        foreach (local obj in vec)
            ret = ret + obj.name + ', ';
        return ret;
    }
;


/*=====================================================================

                            TEST GAME OBJECTS

=====================================================================*/

versionInfo: GameID;
gameMain: GameMainDef initialPlayerChar = me;

modify adv3LibPreinit
    execBeforeMe = [mainOutputStream, statusTagOutputStream,
                    statusLeftOutputStream, statusRightOutputStream,
                    langMessageBuilder, roomGenerator]
;

#define UNDIRECTED__

roomGenerator: PreinitObject
    execute() {
        roomsVector = new Vector(30);
        for(local i = 1 ; i <= 30 ; i++) {
            local newRoom = new Room;
            newRoom.roomName = 'room ' + toString(i);
            roomsVector.append(newRoom);
        }
        for(local i = 1 ; i < 30 ; i++) {
            roomsVector[i].north = roomsVector[i+1];

#ifdef UNDIRECTED__
            roomsVector[i+1].south = roomsVector[i];
#endif
            if(rand(2)) {
                local rndRm = roomsVector[rand(roomsVector.length) +1];
                while (rndRm.west)
                    rndRm = roomsVector[rand(roomsVector.length) +1];
                roomsVector[i].east = rndRm;

#ifdef UNDIRECTED__
                rndRm.west = roomsVector[i];
#endif
            }
        }
    }
    roomsVector = nil
;

modify roomPathFloyd execBeforeMe = [roomGenerator];

modify Room desc() { "<<roomName>>"; };

me: Actor
    location = roomGenerator.roomsVector[1]
;


