#charset "us-ascii"
/* 
 *  Copyright (c) 2006 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the TADS 3 Relation Library Extension
 *
 *  relation.h
 *
 *--------------------------------------------------------------------
 *  THE TADS 3 RELATION HEADER FILE
 *--------------------------------------------------------------------
 */

#include <tads.h>

#pragma	once

/*
 *	A macro for statically defining a SetObject. Name is the
 *	symbolic name of the SetObject.
 */
#define Set(name) \
name: SetObject

/*
 *	A macro for dynamically defining a SetObject. Name is the
 *	string name of the SetObject.
 */
#define MakeSet(name, parms...) (new SetObject(name, parms))

/*
 *	A macro for statically defining a RelationSetObject. Name is the
 *	symbolic name of the RelationSetObject.
 */
#define RelSet(name) \
name: RelationSetObject

/*
 *	A macro for dynamically defining a RelationSetObject. Name is the
 *	string name of the RelationSetObject.
 */
#define MakeRelSet(name) (new RelationSetObject(name))

/*
 *	A macro for statically defining a Relation. Name is the 
 *	symbolic name of the RelationSetObject, while args represent
 *	the parameters of the relation instance.
 */
#define	Element(args...) \
ElementObject \
	parms	= [args]

/* 
 *	A macro for dynamically creating a Relation from within
 *	executable code. Name is the symbolic name of the RelationSetObject
 *	while args represent the parameters of the relation instance.
 */
#define	MakeElem(name, args...) (new ElementObject(name, args))

/*
 *	A macro for removing members of a RelationSetObject. Name is the
 *	symbolic name of the set, while args represent the
 *	search mask to be applied in the removal. Note that
 *	the macro does a SearchAll.
 */
#define Remove(name, args...) (name.remove([args]))

/*
 *	A macro for searching a RelationSetObject. Name is the
 *	symbolic name of the set, while args represent the
 *	search mask to be applied in the search. Note that
 *	the macro does a SearchAll.
 */
#define Search(name, args...) (name.search([args]))

/*
 *  This enumerator represents a wildcard in searches
 *  and relationships.
 */
enum any;

/*
 *  This enumerator represents a null value (no-value) 
 *  in a relationship. This is not the same as nil which 
 *  is treated as a value.
 */
enum null;

/*
 *	This search flag value indicates that only
 *	the first match is to be returned from the set.
 */
enum SearchFirst;

/*
 *	This search flag value indicates that all
 *	matches are to be returned from the set.
 */
enum SearchAll;

+ property location;