#charset "us-ascii"

/* 
 *  Copyright (c) 2008 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the TADS 3 ADV3 Rulebooks library extension
 *
 *  rulebooks.t
 */

#include <t3.h>
#include <tads.h>

/*
 *  This table stores, sorts, and evaluates "Instead of Action" rules.
 */
InsteadOfActionRulebook: Rulebook
;

/*
 *  This table stores, sorts, and evaluates "Before Action" rules.
 */
BeforeActionRulebook: Rulebook
;

/*
 *  This table stores, sorts, and evaluates "Actor Action" rules.
 */
ActorActionRulebook: Rulebook
;

/*
 *  This table stores, sorts, and evaluates "Check Action" rules.
 */
CheckActionRulebook: Rulebook
;

/*
 *  This table stores, sorts, and evaluates "Instead of Exec Action" rules.
 */
InsteadOfExecActionRulebook: Rulebook
;

/*
 *  This table stores, sorts, and evaluates "Exec Action" rules.
 */
ExecActionRulebook: Rulebook
;

/*
 *  This table stores, sorts, and evaluates "After Action" rules.
 */
AfterActionRulebook: Rulebook
;

/*
 *  A base class for "Instead of Action" rules.
 */
class InsteadOfActionRule: Rule
{
    location    = InsteadOfActionRulebook
}

/*
 *  A base class for "Before Action" rules.
 */
class BeforeActionRule: Rule
{
    location    = BeforeActionRulebook
}

/*
 *  A base class for "Actor Action" rules.
 */
class ActorActionRule: Rule
{
    location    = ActorActionRulebook
}

/*
 *  A base class for "Check Action" rules.
 */
class CheckActionRule: Rule
{
    location    = CheckActionRulebook
}

/*
 *  A base class for "Instead of Exec Action" rules.
 */
class InsteadOfExecActionRule: Rule
{
    location    = InsteadOfExecActionRulebook
}

/*
 *  A base class for "Exec Action" rules.
 */
class ExecActionRule: Rule
{
    location    = ExecActionRulebook
}

/*
 *  A base class for "After Action" rules.
 */
class AfterActionRule: Rule
{
    location    = AfterActionRulebook
}