#charset "us-ascii"

/* 
 *  Copyright (c) 2008 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the TADS 3 ADV3 Rulebooks library extension
 *
 *  rules.t
 */

#include <t3.h>
#include <tads.h>
#include <adv3.h>

/*
 *  A base class for GlobalRule.
 *  The value property should be 
 *  set the object you wish to match
 *  for the given global variable.
 */
class GlobalRule: Rule
{
    value   = nil
}

/*
 *  A base class for matching the global player character.
 */
class GplayerCharRule: GlobalRule
{
    exec() 
    { 
        if (gPlayerChar == nil)
            return nil;
        
        return gPlayerChar == value || gPlayerChar.ofKind(value); 
    }
}

/*
 *  A base class for matching the global actor.
 */
class GactorRule: GlobalRule
{
    exec()
    {
        if (gActor == nil)
            return nil;
        
        return gActor == value || gActor.ofKind(value); 
    }
}

/*
 *  A base class for matching the global player character location.
 */
class GplayerCharLocRule: GlobalRule
{
    exec()
    {
        if (gPlayerChar == nil)
            return nil;
        
        if (gPlayerChar.location == nil)
            return nil;
        
        return gPlayerChar.location == value || gPlayerChar.location.ofKind(value); 
    }
}

/*
 *  A base class for matching the global actor location.
 */
class GactorLocRule: GlobalRule
{
    exec() 
    { 
        if (gActor == nil)
            return nil;
        
        if (gActor.location == nil)
            return nil;
        
        return gActor.location == value || gActor.location.ofKind(value); 
    }
}

/*
 *  A base class for matching the global action.
 */
class GactionRule: GlobalRule
{
    exec() 
    {
        if (gAction == nil)
            return nil;

        if (gAction && gAction.isImplicit)
            return nil;

        return gAction == value || gAction.ofKind(value); 
    }
}

/*
 *  A base class for matching the global direct object.
 */
class GdobjRule: GlobalRule
{
    exec()
    {
        if (gDobj == nil)
            return nil;
        
        return gDobj == value || gDobj.ofKind(value); 
    }
}

/*
 *  A base class for matching the global indirect object.
 */
class GiobjRule: GlobalRule
{
    exec()
    {
        if (gIobj == nil)
            return nil;
        
        return gIobj == value || gIobj.ofKind(value); 
    }
}

/*
 *  A base class for matching the game clock time.
 *
 *  For this class use 'start' and 'end' to set 
 *  up ranges (bounded or unbounded) or set the
 *  'value' property for an exact match.
 */
class GctRule: GlobalRule
{
    start   = nil
    end     = nil
        
    exec()
    {
        if (value)
        {
            if (value != Schedulable.gameClockTime)
                return nil;
        }

        if (start)
        {
            if (start > Schedulable.gameClockTime)
                return nil;
        }
         
        if (end)
        {
            if (end < Schedulable.gameClockTime)
                return nil;
        }

        return true;
   }
}