
#ifndef h_unix_h
#define h_unix_h

#include "x11lib.h"

/* some globals */
#define MAXLINE           256                  /* common buffer size */
#define MAXOPTIONS         10                  /* max comline options */
#define MAXPICTURES       256                  /* max picture index */
#define LINEBUF            75                  /* no of scrollable text rows */
#define MAXHISTORY         20                  /* length of command history */

#define COLOUR_BLACK       20                  /* black is palette 20 */
#define COLOUR_WHITE       21                  /* white is palette 21 */
#define COLOUR_SALMON      22                  /* blue is palette  22 */
#define COLOUR_SYSTEM      COLOUR_WHITE        /* default system colour */
#define COLOUR_STATUS      COLOUR_SALMON       /* default status colour */

#define FONT_SYSTEM         0                  /* text window font */
#define FONT_STATUS         1                  /* text window font */

#define CANONICLE_WIDTH   256                  /* expected max width (256) */
#define CANONICLE_HEIGHT  175                  /* expected max height (150) */

#define DESIRED_ROWS       12                  /* desired height of text */

/* methods */
void unix_usage ( void );
int unix_identify_options ( int argc, char *argv[] );
int unix_option ( char *name );
char *unix_option_value ( char *name );
char *unix_request_value ( int x );

/* graphics engine wrappers */
void unix_init_graphics_engine ( void );
void unix_shutdown_graphics_engine ( void );
int unix_set_palette_entry ( int entry, int red, int green, int blue );
void unix_expose_event ( void );
void unix_keyrelease_event ( char, KeySym );

/* display routine wrappers */
void unix_refresh_display ( void );            /* does all the real work */
void unix_refresh_status ( void );
void unix_refresh_picture ( void );
void unix_refresh_text ( void );

int unix_unpack_picture ( int pic, int mode ); /* unpack to cache */
int unix_show_picture ( int pic, int mode );   /* queue up image from cache
						* so that refresh() will
						* display it.
						*/
int unix_put_text ( char *text, int newline ); /* queue up the text, which
						* does rolling inside the
						* scroll buffer, handles
						* the MORE prompt, etc.
						* The refresh routine will
						* do the display.
						*/
int unix_put_status ( char *text );            /* queue up the status line */

/* keyboard handlers */
int unix_query_keybuffer_depth ( void );       /* return depth */
int unix_pop_keybuffer ( void );               /* pop destructively queue */

/* graphics plotting wrappers */
void unix_draw_pixel ( int x, int y );
int unix_query_pixmap_width ( int pic );       /* query after-scale size */
int unix_query_pixmap_height ( int pic );      /* query after-scale size */

/* custom game handlers */
void unix_special_intro ( void );
void pawn_intro ( void );
void myth_intro ( void );

/* command history */
void unix_append_history ( char *command );
int unix_query_history_depth ( void );
char *unix_query_history ( int index );

#endif
