


/*
 * GtkScare is a runner for Adrift text adventure games.
 * This program is released under GNU GPL. See the file COPYING.TXT for
 * details.
 * Copyright (c) 2004 Pallav Nawani
 *
 */



/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gtk/gtk.h"

#include "interface.h"
#include "support.h"
#include "gtkscare.h"
#include "config.h"


/*
 *
 * The main thing.
 *
 */


char fstring[256] = "-adobe-helvetica-medium-r-normal-*-*-120-*-*-*-*-*-*";
Gtk_sdata *idata;

int main (int argc, char **argv)
{

  GtkWidget *main_win;
  GtkCheckMenuItem *menuitem;

  idata = (Gtk_sdata *)malloc(sizeof(Gtk_sdata));
  if(NULL == idata) {
     printf("Unable to malloc memory for idata!\n");
     exit(-1);
  }
  sdata_init(idata);
  read_config();

  /* init gtk */
  gtk_set_locale ();
  gtk_init (&argc, &argv);
  if(argc > 1)
     strncpy(idata->name, argv[1], sizeof(idata->name));

  
  main_win = create_main_win(idata);
  gtk_widget_show (main_win);
 
  idata->mwin = main_win;
  make_tags(idata,
	gtk_text_view_get_buffer(GTK_TEXT_VIEW(idata->textw)));
  
  idata->normal.red   = 0;
  idata->normal.green = 0;
  idata->normal.blue  = 0;
  
  idata->in_fore.red   = 11565;
  idata->in_fore.green = 19018;
  idata->in_fore.blue  = 51400;
  
  idata->out_fore.red   = 17990;
  idata->out_fore.green = 33400;
  idata->out_fore.blue  = 17990;

  menuitem = (GtkCheckMenuItem *)lookup_widget(main_win, "verbose_mode");
  gtk_check_menu_item_set_active(menuitem, idata->verbose);

  /* Decorations :) */
  gtk_window_set_icon((GtkWindow *)main_win, idata->gp);
  
  /* Enter main loop */
  gtk_main ();

  write_config();

  free(idata);
  return 0;
}

