/*
 * Decompiled with CFR 0.152.
 */
package mdh.aiee;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import mdh.aiee.Adventure;
import mdh.aiee.CmdAsk;
import mdh.aiee.CmdGuard;
import mdh.aiee.Command;
import mdh.aiee.Entity;
import mdh.aiee.Global;
import mdh.aiee.Stuff;
import mdh.aiee.Thing;

public final class Actor
extends Entity {
    public static final int NEUTER = 0;
    public static final int MALE = 1;
    public static final int FEMALE = 2;
    public static final String[] GENDER_NAME = new String[]{"neuter", "male", "female"};
    private int gender_;
    private Command give_;
    private HashMap guard_;
    private Command hurt_;
    private ArrayList asks_ = new ArrayList(1);
    private CmdAsk askDefault_;
    private Command observe_;

    public Actor(String id, String name) {
        super(id, name);
    }

    public void addAsk(CmdAsk c) {
        if (c.getSubject() != null) {
            this.asks_.add(c);
        } else if (this.askDefault_ == null) {
            this.askDefault_ = c;
        } else {
            throw new IllegalArgumentException("Duplicate default ask in actor " + this.id() + "!");
        }
    }

    public void announceDamage(int d) {
        String s = d > 0 ? Global.join(this.theName() + " takes ", String.valueOf(d), " hits of damage!") : (d == 0 ? this.theName() + " takes no hits of damage." : Global.join(this.theName() + " recovers ", String.valueOf(-d), " hits of damage!"));
        this.findLoc().broadcast(s);
    }

    public void dieDefault() {
        Stuff loc = this.findLoc();
        loc.broadcast(Global.join(this.theName(), " dies!"));
        this.moveto(null);
        StringBuffer sb = null;
        for (int i = this.countContents() - 1; i >= 0; --i) {
            Thing it = this.findContents(i);
            it.moveto(loc);
            if (sb == null) {
                sb = new StringBuffer(80);
                sb.append(this.theName()).append(" drops ");
            } else {
                sb.append(',').append(' ');
            }
            sb.append(it.aName());
        }
        if (sb != null) {
            sb.append('.');
            loc.broadcast(sb.toString());
        }
    }

    public CmdAsk findAsk(String text) {
        String lower = text.toLowerCase();
        int len = this.asks_.size();
        for (int i = 0; i < len; ++i) {
            CmdAsk ask = (CmdAsk)this.asks_.get(i);
            if (lower.indexOf(ask.getSubject()) < 0) continue;
            return ask;
        }
        return this.askDefault_;
    }

    public void hurt() {
        if (this.hurt_ != null) {
            this.hurt_.doEval(Adventure.getAdv(), this);
        }
    }

    public int getGender() {
        return this.gender_;
    }

    public Command getGive() {
        return this.give_;
    }

    public CmdGuard getGuard(String dir) {
        if (this.guard_ == null) {
            return null;
        }
        return (CmdGuard)this.guard_.get(dir);
    }

    public Command getHurt() {
        return this.hurt_;
    }

    public Command getObserve() {
        return this.observe_;
    }

    public void setGender(String g) {
        if (g != null && g.length() == 1) {
            switch (g.charAt(0)) {
                case 'n': {
                    this.gender_ = 0;
                    return;
                }
                case 'm': {
                    this.gender_ = 1;
                    return;
                }
                case 'f': {
                    this.gender_ = 2;
                    return;
                }
            }
        }
        throw new IllegalArgumentException("Unknown gender '" + g + "'");
    }

    public void setGive(Command cmd) {
        this.give_ = cmd;
    }

    public void setGuard(String dir, CmdGuard cmd) {
        if (this.guard_ == null) {
            this.guard_ = new HashMap(3);
        }
        this.guard_.put(dir, cmd);
    }

    public void setHurt(Command h) {
        this.hurt_ = h;
    }

    public void setObserve(Command observe) {
        this.observe_ = observe;
    }

    protected void toString2(StringBuffer sb) {
        sb.append(" gender=\"").append(GENDER_NAME[this.gender_].charAt(0)).append('\"');
        super.toString2(sb);
        if (this.guard_ != null) {
            Iterator it = this.guard_.values().iterator();
            while (it.hasNext()) {
                sb.append('\n').append(it.next());
            }
        }
        if (this.give_ != null) {
            sb.append(this.give_);
        }
        if (this.hurt_ != null) {
            sb.append(this.hurt_);
        }
    }
}

