
/* This file defines the API for the PICKLE Editor Library. 
	Version 1. */

/* You must include pickle.h before including this file. */

/* This library includes everything in the PICKLE Reader Library,
	plus a bunch of extra functions which are useful for analyzing
	and writing out PICKLE files. */


#define pikerr_CantWrite (21)

struct pikIndChunkData {
	pikLong startpos; 
	pikLong length;
	pikType use;
	pikLong number;
	pikFormat format;
	pikChunkID id;
};
typedef struct pikIndChunkData pikIndChunk;

typedef struct pikBuilderChunkData pikBuilderChunk;
typedef struct pikBuilderData *pikBuilderPtr;

#ifdef __STDC__

extern void pikxTypeToString(pikType type, char *result);
extern pikErr pikxGetChunkCount(pikMapPtr map, pikLong *num);
extern pikErr pikxFindIndChunk(pikMapPtr map, pikLong num, pikIndChunk *found);
extern pikErr pikxCreateBuilder(pikBuilderPtr *newmap);
extern pikErr pikxDestroyBuilder(pikBuilderPtr map);
extern pikErr pikxBuilderAdd(pikBuilderPtr map, pikChunkID *newid, 
	pikType use, pikLong number, pikFormat format, 
	pikLong startpos, pikLong length, char *filename);
extern pikErr pikxBuilderDelete(pikBuilderPtr map, pikChunkID id);
extern pikErr pikxBuilderBuild(pikBuilderPtr map, FILE *file);

#else

extern void pikxTypeToString();
extern pikErr pikxGetChunkCount();
extern pikErr pikxFindIndChunk();
extern pikErr pikxCreateBuilder();
extern pikErr pikxDestroyBuilder();
extern pikErr pikxBuilderAdd();
extern pikErr pikxBuilderDelete();
extern pikErr pikxBuilderBuild();

#endif

