/* cdos.c: CSCR dos/djgpp interface
    This implements cscr as native PC-bios functions for use with 
    cscr, and adds a screen capture facility

    By L. Ross Raszewski <lraszewski@justice.loyola.edu>

*/
#include <stdio.h>
#include <stdarg.h>
#include <unistd.h>
#include "cscr.h"
#include <dpmi.h>
#include <pc.h>
#include <bios.h>
#include <string.h>
#include "gtpref.h"
#include <go32.h>
#include <sys/movedata.h>
#include <stdlib.h>
#include "mouse.h"
// Fake definitions to keep allegro happy

int VHORIZ_REZ;
int VVERT_REZ;

// Exportable meaningful variables
int LINES;
int COLS;
struct mouse_info_s mouse_info;
// Extended character printing table. This is very complex; we print
// The characters that have corresponding MDA characters, translating
// from latin1 to MDA
unsigned char OPT_AO_FF_OUTPUT[]= {
        0,   173, 155, 156, 15 , 157, '|', 21,
        0,     0, 166, 174, 170, '-',   0,   0,
        248, 241, 253,   0, '\'', 230, 20, 249,
        0,     0, 167, 175, 172,  171,  0, 168,
        0,     0,   0,   0, 142, 143,  146, 128,
        0,   144,   0,   0,  0,   0,   0,   0,  
        0,   165,   0,   0,  0,  0,  163,  0,   
        0,   0,   0,   0,154,  0,   0,   225, 
        133, 160, 131,  0, 132, 134, 145, 135,  
        130, 130, 136, 137, 141, 161, 140, 139, 
        0,   164, 149, 161, 147, 0, 148, 246,   
        237, 163, 151, 150, 129, 0, 0, 152,     
         };


// Internal variables
static char c_printscanbuf[1024];       // buffer for printf
static int scr_x,scr_y;                 // the cursor
static unsigned int scr_attrib=0x070000;    // the text output attribute
static unsigned int bk;                 // the background attribute
static unsigned short int *screen;      // the virtual screen

static unsigned short int *oldscreen;    // the screen state at startup
static int oldx;
static int oldy;

static int mouse_exists;                // Indicates success of init_mouse
static int mouse_click=0;               // Indicates a pending click
static int mouse_alive=0;               // Indicates the mouse is active

// Internal functions

// Convert a curses-style character to a bios character
static short chtype_to_bios(unsigned int x)
{
 unsigned int a;
 a=x >> 24;
 if (x & A_BOLD) a|=0x8;
 if (x & A_BGBRITE) a|=0x80;
 if (x & A_DIM) a &=~0x8;
 if (x & A_REVERSE) a = ((a &0xf) << 4) | ((a&0xf0) >> 4);
 x=(x&0xff)| a <<8;
 return x;
}
// Add a character to the screen buffer.
static void deep_addch(unsigned int c,int x, int y)
{
 *(screen+(y*COLS)+x)=chtype_to_bios(c);
}

// Kick into intense video mode.
static void ivideo(void)
{
  __dpmi_regs regs;
  regs.h.bl = 0;
  regs.x.ax = 0x1003;
  __dpmi_int(0x10, &regs);
}

// Convert xkey into curses-style 
static int keyconv(int c)
{

if (c>=315 && c<=322) return  c-315+265;
else if (c>=350 && c<=358) return c-350+285;
else if (c>=360 && c<=368) return c-360+295;
else
switch(c)
{
   case 583: return KEY_HOME;
   case 584: return KEY_UP;
   case 585: return KEY_PAGEUP;
   case 587: return KEY_LEFT;
   case 589: return KEY_RIGHT;
   case 591: return KEY_END;
   case 592: return KEY_DOWN;
   case 593: return KEY_PAGEDN;
   case 594: return KEY_INSERT;
   case 595: return KEY_DELETE;
   case 629: return CTL_END;
   case 631: return CTL_HOME;
   case 658: return 477;
   case 659: return 467;
   case 418: return 479;
};
return c;
}

// Get the state of the mouse
static int poll_mouse()
{
 if (!mouse_alive) return 0;
 if (mouse_click) return 1;
 mouse_click=get_mouse(&mouse_info.x,&mouse_info.y);
 if (mouse_click)
 {
   mouse_info.text_x=(mouse_info.x * COLS)/ 640;
   mouse_info.text_y=(mouse_info.y * LINES)/200;
//   scale the mouse location from bios-co-ordinates to charpos
   return 1;
 }
 return 0;
}

// cdos: DOS/DJGPP implementation of cscr
// Group 1
int cscr_version()
{
 return CSCR_DOS;
}

void cscr_start()
{
    ivideo();
    COLS=ScreenCols();
    LINES=ScreenRows();
    screen=(unsigned short *)malloc(COLS*LINES*sizeof(short));
    oldscreen=(unsigned short *)malloc(COLS*LINES*sizeof(short));
    ScreenRetrieve(oldscreen);
    ScreenGetCursor(&oldy,&oldx);
    bk=glk_preferences[pref_fg_color] << 8 | glk_preferences[pref_bg_color] << 12;
    scr_attrib=(bk& 0xff00) << 16;
    mouse_exists=(init_mouse()!=0);
}

void cscr_exit()
{
 cscr_suspend();
 cscr_sleep_mouse();
 ScreenUpdate(oldscreen);
 ScreenSetCursor(oldy,oldx);
 free(oldscreen);
 free(screen);
}
void cscr_resume()
{
 ivideo();
 cscr_refresh();
}
void cscr_suspend()
{
 ScreenAttrib=7;
 ScreenClear();

}



// Group 2
void  cscr_charpos_to_pxl(int *x, int *y)
{
 // Do nothing! charpos _are_ screen units
}
unsigned int cscr_getcols()
{
 return COLS;
}

unsigned int cscr_getlines()
{
 return LINES;
}

// Group 3
void cscr_wake_mouse()
{
 if (mouse_alive) return;
 mouse_alive=1;
 show_mouse();
}
void cscr_sleep_mouse()
{
 if (!mouse_alive) return;
 mouse_alive=0;
 hide_mouse();
}
int cscr_query_mouse()
{
 return mouse_exists;
}


// Group 4a
void cscr_clear()
{
 int i,j;
 for(i=0;i<LINES;i++)
  for(j=0;j<COLS;j++) *(screen+(i*COLS)+j)=(bk&0xff00)|' ';
}
void cscr_clrtoeol()
{
 int x;
 for(x=scr_x;x < COLS;x++)
  *(screen+scr_y*COLS+x)=(bk&0xff00)|' ';
}
void cscr_refresh()
{
 while(!(inportb(0x3da)&8));
 ScreenUpdate(screen);
}
void cscr_moveyx(int y, int x)
{
 scr_y=y;
 scr_x=x;
}
void cscr_screencap()
{
 int i,j;
 FILE *f;
 char s[13];
 static int n=0;
 do {
  sprintf(s,"scr%05d.txt",n);
  n++;
  }
 while(__file_exists(s) && n < 100000);
 if (n>99999) return;
 f=fopen(s,"w");
 for(i=0;i<LINES;i++)
 {
  for(j=0;j<COLS;j++)
   putc(*(screen+(COLS*i+j)) & 0xff,f);
  putc('\n',f);
 }
 fclose(f);
}

// Group 4b
int cscr_addstr(char *s)
{
 int i=0;
 while(*s)
 {
  i++;
  if (*s==10) scr_x=0;
  else if (*s==13 && scr_y!=LINES) scr_y++;
  else cscr_addch(*s);
  s++;
 }
 return i;
}
void cscr_addch(chtype c)
{
  c=(c &0xff)| (scr_attrib & 0xffffff00);  
  deep_addch(c,scr_x, scr_y);
  if (scr_x!=79) scr_x++;
}
int cscr_printw(char *fmt, ...)
{
 va_list args;
 int retval=ERR;
 va_start(args,fmt);

	vsprintf(c_printscanbuf, fmt, args);
	va_end(args);
        if (cscr_addstr(c_printscanbuf) == ERR)
		return (retval);
	retval = (strlen(c_printscanbuf));
	return (retval);

}

// Group 4c
chtype cscr_color(int f, int b)
{
  return (f << 24 | b << 28)&0xff000000;
}
unsigned char cscr_color_to_8bit(chtype c)
{
 return c >> 24;
}
void cscr_attron(chtype a)
{
 scr_attrib|=a;
}
void cscr_attrset(chtype x)
{
 if (x)
 scr_attrib=x;
 else scr_attrib=(bk&0xff00) << 16;
}
chtype cscr_bkgd(chtype i)
{
 bk=chtype_to_bios(i);
 return bk;
}

// Group 5

int cscr_kbhit()
{
 if (poll_mouse()) return 1;
 return bioskey(1);
}
void cscr_blinkey()
{
 ScreenSetCursor(scr_y,scr_x);
}
chtype cscr_getch()
{
 cscr_refresh();
 if (poll_mouse()) { mouse_click=0; return MOUSE_CLICK_KEY; } 
 return keyconv(getxkey());
}

