/* gtstyle.c: Style formatting hints.
        for GlkDOS, curses.h/allegro implementation of the Glk API
    Designed by L. Ross Raszewski <lraszewski@justice.loyola.edu>
    
    based upon GlkTerm by Andrew Plotkin <erkyrath@netcom.com>
    http://www.eblong.com/zarf/glk/index.html
*/

#include "gtoption.h"
#include <stdio.h>

#include "cscr.h"
#include "glk.h"
#include "glkdos.h"
#include "gtw_grid.h"
#include "gtw_buf.h"
extern chtype style_mask[];
extern chtype def_style_mask[];

unsigned char   tocursescolor(glui32 c)
{
  int blue=c&0xff; int green=(c >>8)&0xff; int red=(c>>16) &0xff;
  int k;
  k=(blue>0x7f) |(red>0x7f) | (green > 0x7f);
  return ((k>0) << 3) | ((red>0) <<2) | ((green>0) <<1) | (blue>0);
}

void glk_stylehint_set(glui32 wintype, glui32 styl, glui32 hint, 
    glsi32 val)
{
  switch(hint)
  {
    case stylehint_Weight:
     if (val==1) {
                  if (style_mask[styl]&0x400000) break;
          style_mask[styl]=(style_mask[styl]|0x4000)& ~0x2000;
          }
     else if (val==-1) {
        if (style_mask[styl]&0x200000) break;
        style_mask[styl]=(style_mask[styl]|0x2000)& ~0x4000;
        }
     else if (style_mask[styl]&0x100000) break;
     else style_mask[styl]&= ~(0x6000);
     setup_curses();break;

    case stylehint_TextColor:
        if (style_mask[styl]&0x10000) break;
        style_mask[styl]=(style_mask[styl]& ~0x010f)| tocursescolor(val);
        setup_curses();break;        
   case  stylehint_BackColor:
        if (style_mask[styl]&0x20000) break;
        style_mask[styl]=(style_mask[styl]& ~0x02f0)| (tocursescolor(val) << 4);
        setup_curses();break;        
   case stylehint_ReverseColor:
        if (style_mask[styl]&0x100000) break;        
         style_mask[styl]|=(val) <<16;
         setup_curses();break;        
  }
}

void glk_stylehint_clear(glui32 wintype, glui32 styl, glui32 hint)
{
 switch(hint)
  {
    case stylehint_Weight:
     if (style_mask[styl]&0x600000) break;
     style_mask[styl]&= ~(0x6000);
     setup_curses();break;

    case stylehint_TextColor:
        if (style_mask[styl]&0x10000) break;
        style_mask[styl]=(style_mask[styl] & 0xFEF0) | (def_style_mask[styl] & 0x010F);
        setup_curses();break;
   case  stylehint_BackColor:
        if (style_mask[styl]&0x20000) break;
        style_mask[styl]=(style_mask[styl] & 0xFD0F) | (def_style_mask[styl] & 0x02F0);
        setup_curses();break;
   case stylehint_ReverseColor:
        if (style_mask[styl]&0x100000) break;
        style_mask[styl]=(style_mask[styl] & 0xEFFF) | (def_style_mask[styl] & 0x1000);
        setup_curses();break;
  }

}
unsigned char styletocolor(glui32 style);
glui32 glk_style_distinguish(window_t *win, glui32 styl1, glui32 styl2)
{
    chtype *styleattrs;

    if (!win) {
        gli_strict_warning("style_distinguish: invalid ref");
        return FALSE;
    }
    
    if (styl1 >= style_NUMSTYLES || styl2 >= style_NUMSTYLES)
        return FALSE;
/*    
    switch (win->type) {
        case wintype_TextBuffer:
            styleattrs = win_textbuffer_styleattrs;
            break;
        case wintype_TextGrid:
            styleattrs = win_textgrid_styleattrs;
            break;
        default:
            return FALSE;
    }
*/
  if (win->type!= wintype_TextBuffer && win->type!= wintype_TextGrid) return FALSE;
  styleattrs=win->winstyle;

    /* styleattrs is an array of chtype values, as defined in curses.h. */
    
    if (styleattrs[styl1] == styleattrs[styl2])
        return FALSE;
    else  if (styletocolor(style_mask[styl1]) !=
              styletocolor(style_mask[styl2])) return TRUE;

    return FALSE;
}


glui32 toglkcolor(char c)
{
  int blue=c&1; int green=c&2; int red=c&4; int k=(c&8)+1;
  blue*=k * 0x7f;
  green*=k * 0x7f00;
  red*=k * 0x7f0000;
  if (k) {blue++; red +=0x10000; green+=0x100;}
  return blue | red | green;
}

glui32 glk_style_measure(window_t *win, glui32 styl, glui32 hint, 
    glui32 *result)
{
    chtype *styleattrs;
    glui32 dummy;

    if (!win) {
        gli_strict_warning("style_measure: invalid ref");
        return FALSE;
    }
    
    if (styl >= style_NUMSTYLES || hint >= stylehint_NUMHINTS)
        return FALSE;
    
/*    switch (win->type) {
        case wintype_TextBuffer:
            styleattrs = win_textbuffer_styleattrs;
            break;
        case wintype_TextGrid:
            styleattrs = win_textgrid_styleattrs;
            break;
        default:
            return FALSE;
    }
*/
  if (win->type!= wintype_TextBuffer && win->type!= wintype_TextGrid) return FALSE;
  styleattrs=win->winstyle;
    if (!result)
        result = &dummy;
    
    switch (hint) {
        case stylehint_Indentation:
        case stylehint_ParaIndentation:
            *result = 0;
            return TRUE;
        case stylehint_Justification:
            *result = stylehint_just_LeftFlush;
            return TRUE;
        case stylehint_Size:
            *result = 1;
            return TRUE;
        case stylehint_Weight:
            *result = (style_mask[styl] & 0x400)==0;
                      
            return TRUE;
        case stylehint_ReverseColor:
             *result = (style_mask[styl] & 0x1000)!=0;
             return TRUE;
        case stylehint_Oblique:
        case stylehint_Proportional:
            *result = FALSE;
            return TRUE;
        case stylehint_TextColor:
            *result= toglkcolor(style_mask[styl] & 0xf);
            return TRUE;
        case stylehint_BackColor:
            *result= toglkcolor(style_mask[styl] & 0xf0 >> 4);
            return TRUE;

    }
    
    return FALSE;
}
