

package org.ifarchive.glk;

/** The retained array registry allows a user program to be called when 
 * arrays are retained and released.
 * 
 * <p>In Java, do this by implementing the ArrayRegistry interface, and
 * calling Glk.setArrayRegistry().
 *
 * @see Glk#setArrayRegistry
 * @author John Elliott
 * @version 1.0 */

public interface ArrayRegistry
{
	/** Register an array.
	 * @param obj The array to register. It will be an array type.
	 * @param typecode The object's Glk type.
	 * @return A dispatch rock that will be associated with this object.
	 */  
	public Object reg(Object obj, String typecode);
	/** Unregister an array.
	 * @param obj The array to unregister.
	 * @param typecode The object's Glk type.
	 * @param rock The object's dispatch rock.
	 */  
	public void unreg(Object obj, String typecode, Object rock);
}
