! ----------------------------- CAMuerte.h ----------------------------
! ------------------------ Combate a Muerte 1.0 -----------------------
! ------------- Libreria por Pablo D'Amico para InformATE -------------
! -- Para utilizarla slo hay que declararla al principio de tu .inf --

! Funcionamiento
! --------------
! El objetivo de esta librera es proporcionar funciones que simplifiquen el combate con
! armas cuerpo a cuerpo entre el Pjugador y los enemigos que puede encontrarse.
! Para eso podra usarse una clase enemigo o algo parecido, que incluya las propiedades:
! ganador y perdedor, el atributo animado y la rutina de vida que capture atacar.
! sin embargo para preservar compatibilidad con otras librerias (como fhablaoo.h o PNJMovil.h)
! dicha creacin queda a discrecin del programador.
! Bastar con asegurarse que cada potencial enemigo posea dichas caractersticas al momento de
! crearlo. Un ejemplo completo del uso de esta libreria es pepe.inf (que se distribuye con esta libreria)
! El funcionamiento bsico es el siguiente: cuando el jugador ataca a un PNJ este llama
! a la rutina combate, que determinar quien gane de acuerdo a las armas empleadas.
! Aclaracin:
! El soporte para mltiples personajes no ha sido testeado. (El uso de esta opcin
! requerir de la creacin de los objetos jugadores, asignndoles la propiedad pvida
! a cada uno de ellos. Sin embargo PuntosDeVida seguir siendo usada internamente por la librera)

! Har falta la declaracin de estas variables para el funcionamiento de la rutina de combate:
Global	  MPJs=false;		!Poner esta variable en true si hay mltiples personajes
							!Es decir que jugador puede tomar ms de un valor
Global    PuntosDeVida;		!Almacena los puntos de dao que resiste el jugador (en modo de un solo PJ)
Global    ArmaActual=NULL;	!Apunta al Arma actualmente en uso
Global    ArmaBuffer;		!Apunta al estado anterior de ArmaActual
Global	  ArmaDefault;		!Apunta al Arma a utilizar por defecto
Global    temp;				!Auxiliar usada por combate

! Las propiedades que deben tener los enemigos del jugador:
Property  ganador;		!Indica que debe realizarse si el enemigo gana la pelea (el jugador muere)
Property  perdedor;		!Indica que debe realizarse si el jugador gana la pelea (el enemigo pierde)
Property  pvida;		!Indica los puntos de dao que resiste el enemigo (o los personajes)

! Atributos de un arma
Attribute blandida; 	!Este atributo determinar si un arma es empuada por el jugador en este momento
Attribute grandote; 	!Este atributo indica que el arma no es apropiada para guardarla en recipientes

! --------------------------- La Clase Arma ---------------------------
! Debe ser declarada la clase Arma que har uso de los atributos de arriba.
! Todas las armas que pueda usar el jugador o sus enemigos deben pertnecer a esta clase
! La clase capturar los verbos blandir y enfundar que son definidos ms abajo
! y determinar que arma lleva el jugador almacenndola en ArmaActual, si no lleva ningn arma,
! ArmaActual tendr el valor NULL. Esta clase tambin se ocupa de indicar si el arma est blandida
! mediante el atributo de dicho nombre al momento de listarla en el inventario
! por ltimo el atributo grandote podr ser chequeado por un objeto de tipo recipiente
! al querer meter el arma en el mismo (dejo esto ltimo a discrecin del programador)

Class Arma,
with dano_arma 1,	!Nmero de puntos de dao que hace (de cero a dano_arma)
	 dano_min 0,	!Dao mnimo que realiza el arma (total=dano_arma+dano_min)
	 base_ataque 20,!Porcentaje mnimo de posibilidad de ataque exitoso
					!(puede modificarse dependiendo de quien la use)
	 antes[;
		blandir:
			if(uno notin jugador) "Debes tener ", (el) uno, " para poder blandirlo.";
			if(self has blandida) "Ya ests blandiendo ", (el) uno, ".";
			else{
			if(jugador hasnt general){
				give self blandida;
				give jugador general;	!Indica si el jugador lleva blandiendo un arma
				ArmaActual=self;
				"Blandes ",(el) uno,".";}
			else "Primero enfunda el arma que ests llevando.";}
		enfundar:
			if(self hasnt blandida) "No ests blandiendo ",(el) uno,".";
			else{
				give self ~blandida;
				give jugador ~general;
				ArmaActual=NULL;
				"Enfundas ", (el) uno,".";}
			],
	 listarse[;
		if (etapa_inventario==1) return false;
		if (etapa_inventario==2){if(self has blandida) print" (que llevas blandiendo)";}
		],
has grandote;

! ------------------------- La rutina Combate -------------------------
! La secuencia de combate debe ser llamada ante la accin atacar
! Al llamarla se le pasan dos argumentos: arma (del enemigo) y enemigo (el objeto)
! El arma que est usando el jugador se guarda en ArmaActual mediante los verbos blandir y enfundar
! Si no ha empuado ningn arma se intentar usar el ArmaDefault y si no se puede no habr combate
! Esta funcin no retorna true, por lo que luego de llamarla debers hacerlo desde la
! propiedad vida en el enemigo, de lo contrario te encontrars despus del resultado con
! el mensaje: "La violencia no es la solucin"

[ Combate enemigo arma;
	if(ArmaActual==NULL)
		{
		if(ArmaDefault notin Jugador) "Necesitas blandir un arma antes de atacar.";
		else
			{
			ArmaActual=ArmaDefault;
			print "Blandes tu ", (_nombre_) ArmaDefault, ".";
			}
		}
	!Guardo el arma del jugador en ArmaBuffer
	ArmaBuffer=ArmaActual;
	for(:true:) !Repetir indefinidamente
	{
		!Almaceno en temp el resultado del chequeo del ArmaActual(del jugador)
		temp=chequeo();
		if(temp<1) print "^No le atinas a ",(_nombre_) enemigo,".^^";
			else{!Resta del enemigo los puntos de dao recibidos
				 enemigo.pvida=enemigo.pvida-temp;
				 print "^Impactas a ",(_nombre_) enemigo, ".^^";
				}
		if(self.pvida<1){ !Llama a enemigo.perdedor y termina el ciclo
			enemigo.perdedor();break;}
		!Cambio de arma actual
		ArmaActual=arma;
		!Llamo de nuevo a chequeo (para enemigo)
		temp=chequeo();
		if(temp<1) print (_nombre_) enemigo, " no te atina.^";
			else{!Resta los puntos de dao recibidos por el jugador
				 if(MPJs==false) PuntosDeVida=PuntosDeVida-temp;
				 else jugador.pvida=jugador.pvida-temp;
				 !El verbo Res, muestra los PuntosDeVida
				 print (_nombre_) enemigo," te impacta. ";<res>;
				}
		ArmaActual=ArmaBuffer;
		if(MPJs==true) PuntosDeVida=jugador.pvida;
		if(PuntosDeVida<1){ !Llama a enemigo.ganador y termina el ciclo
			enemigo.ganador();break;}
	}
];

! ------------------------- Funcin Chequeo -------------------------
! Esta funcin retorna cero cuando no se ha podido impactar con el arma u otro valor nmerico
! si se ha podido lograr con xito dicha accin. La cantidad de este valor determinar el dao
! causado por el arma en cuestin (ArmaActual)

[ Chequeo;
	if(ArmaActual~=NULL){
	if (random(100)<=ArmaActual.base_ataque)
		return(random(ArmaActual.dano_arma)+ArmaActual.dano_min+1);
	else return 0;}
];

! ------------------- Soporte para los verbos nuevos -------------------
! Estas son las rutinas de respuesta predeterminada de los nuevos verbos

[ BlandirSub;
	"No puedes blandir ",(el) uno,".";
];

[ EnfundarSub;
	"No puedes enfundar ",(el) uno,".";
];

! Permite a jugador conocer sus puntos de vida

[ ResSub;
	if(MPJs==true)PuntosDeVida=jugador.pvida;
	"Puntos de vida: ", PuntosDeVida;
];

! Estos son los verbos utilizados por esta libreria 

Verb 'v' 'vida'
    *					-> Res;

Verb 'blande' 'desenfunda'
    * noun   			-> Blandir;

Verb 'enfunda' 'guarda'
    * noun   			-> Enfundar;
