!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2003.06.08 ORReferByContents	[Z, GLULX]
! An object that can be refered to by the name of what it contains.  For instance a 
! glass of water can be taken by the command "get water".
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! AutoDep :	none
!--------------------------------------------------------------------------------------
! A more detailed description of this file, what it does, and how to use it goes here.
!
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#include "ORReferByContents";					!Constant USE_ORReferByContents; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORReferByContents; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.02.22	Initial Creation (not really, but this is the earliest date I could find
!				without searching my code archive)
! 2002.02.26	Fit to new template
! 2003.02.18	Made modifications to support ORAdjective, also fixed a signed comparsion problem
!				that occurs in large games.
! 2003.06.08	Made modifications to stop the parse_name routine from signalling "NO MATCH",
!				rather it now passes control back to the parser in the event that it cannot 
!				validate the object against the input.  Other routines, such as ORAdjective, 
!				might be more successful.
!--------------------------------------------------------------------------------------
#ifdef USE_ORReferByContents;message "          Processing library extension ORReferByContents...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORReferByContents_DONEREPLACE; constant ORReferByContents_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORReferByContents_DONEMESSAGE; constant ORReferByContents_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORReferByContents requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------
	class ORReferByContents
		with	refer_actions 0 
		,		ignore_actions 0
		,		match_name[w o;
					if(WordInProperty(w,self,name)==true && self.discount(w,self)==false)
						rtrue;
					else{ 
						objectloop(o in self) {
							if(WordInProperty(w,o,name)==true && self.discount(w,o)==false)
								rtrue;
						}
					}
					rfalse;
				]
		,		discount[w o i;w=w;o=o;i=i;
	#ifdef USE_ORAdjective;
					if((o provides adjective)==false) rfalse;
					i=WordInProperty(w,o,adjective);
					return i;
	#ifnot;
					rfalse;
	#endif;
				]
		,		match_short_name[w swn o; w=w;o=o;
	#ifdef USE_ORRecogName;
						if(MatchAgainstShortName(self,swn)==true && self.discount(w,self)==false)
							rtrue;
						else{ 
							objectloop(o in self) {
								if(MatchAgainstShortName(o,swn)==true && self.discount(w,o)==false)
									rtrue;
							}
						}
						rfalse;
	#ifnot;
						rfalse;
	#endif;
				]
		,		parse_name[w found count svdwn passedinwn;
					if(parser_action==##TheSame) return 0; !--don't try to differentiate between similar objects
					
					if (found_ttype==HELD_TOKEN && (self in actor)==false && self has static or scenery) return -1;
					if(self.refer_actions~=0 && WordInProperty(action_to_be,self,refer_actions)==false) return -1;
					if(self.ignore_actions~=0 && WordInProperty(action_to_be,self,ignore_actions)==true) return -1;
					passedinwn=wn;
					do{
						found=false;
						svdwn=wn;
						w=NextWord();
						if(w~=0) found=self.match_name(w);
						if(found==false || w==0) found=self.match_short_name(w, svdwn);
						if(found==true) count++; 
					}until(found==false);
					if(count>0) return count;
					wn=passedinwn; !--restore the passed in wn
					return -1; 
				]
	;
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORReferByContents_DONECODE;constant ORReferByContents_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORReferByContents_DONEGRAMMAR; constant ORReferByContents_DONEGRAMMAR; #ifdef ORReferByContents_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;
