# hc.exe makefile
# for lcc

TARGET=hc.exe

# PORT_NAME is for file-naming:
PORT_NAME=lcc
COMPILE=lcc
LINK=lcclnk

# Instead of specifying directories, we'll use a make.bat to
# copy all source files to the current directory--lcc doesn't
# seem to want to put .obj files where it's told
#SOURCE_DIR=c:/hugo/source
SOURCE_DIR=.
#NONPORTABLE_DIR=c:/hugo/source/lcc
NONPORTABLE_DIR=.

OBJ_EXT=obj
NONPORTABLE_OBJS=hc$(PORT_NAME).$(OBJ_EXT) 

DEFINES=-DLCCWIN32
WFLAGS=
#DFLAGS=-g
OFLAGS=
CFLAGS=-Ic:/hugo/source -I$(SOURCE_DIR) $(WFLAGS) $(DFLAGS) $(OFLAGS) $(DEFINES) -c

OBJS=hc.$(OBJ_EXT) hcbuild.$(OBJ_EXT) hccode.$(OBJ_EXT) \
hccomp.$(OBJ_EXT) hcdef.$(OBJ_EXT) hcfile.$(OBJ_EXT) \
hclink.$(OBJ_EXT) hcmisc.$(OBJ_EXT) hcpass.$(OBJ_EXT) \
hcres.$(OBJ_EXT) stringfn.$(OBJ_EXT) \
$(NONPORTABLE_OBJS)

$(TARGET): $(OBJS)
	$(LINK) -o $(TARGET) $(OBJS)

# Portable sources:

hc.$(OBJ_EXT): $(SOURCE_DIR)/hc.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/hc.c

hcbuild.$(OBJ_EXT): $(SOURCE_DIR)/hcbuild.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/hcbuild.c

hccode.$(OBJ_EXT): $(SOURCE_DIR)/hccode.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/hccode.c

hccomp.$(OBJ_EXT): $(SOURCE_DIR)/hccomp.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/hccomp.c

hcdef.$(OBJ_EXT): $(SOURCE_DIR)/hcdef.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/hcdef.c

hcfile.$(OBJ_EXT): $(SOURCE_DIR)/hcfile.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/hcfile.c

hclink.$(OBJ_EXT): $(SOURCE_DIR)/hclink.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/hclink.c

hcmisc.$(OBJ_EXT): $(SOURCE_DIR)/hcmisc.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/hcmisc.c

hcpass.$(OBJ_EXT): $(SOURCE_DIR)/hcpass.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/hcpass.c

hcres.$(OBJ_EXT): $(SOURCE_DIR)/hcres.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/hcres.c

stringfn.$(OBJ_EXT): $(SOURCE_DIR)/stringfn.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/stringfn.c


# Non-portable sources:

hc$(PORT_NAME).$(OBJ_EXT): $(NONPORTABLE_DIR)/hc$(PORT_NAME).c
	$(COMPILE) $(CFLAGS) $(NONPORTABLE_DIR)/hc$(PORT_NAME).c
