# hdwin.exe makefile
# for lcc

TARGET=hdwin.exe

# PORT_NAME is for file-naming:
PORT_NAME=lcc
COMPILE=lcc
LINK=lcclnk

# Instead of specifying directories, we'll use a make.bat to
# copy all source files to the current directory--lcc doesn't
# seem to want to put .$(OBJ_EXT) files where it's told
#SOURCE_DIR=c:/hugo/source
SOURCE_DIR=.
#NONPORTABLE_DIR=c:/hugo/source/lcc
NONPORTABLE_DIR=.

OBJ_EXT=obj

NONPORTABLE_OBJS=he$(PORT_NAME).$(OBJ_EXT) hejpeg.$(OBJ_EXT) \
hesound.$(OBJ_EXT) hd$(PORT_NAME).$(OBJ_EXT) hewin.obj hdwin.obj \
hdnewwin.obj hdwin.res hesound_nt.obj

DEFINES=-DLCCWIN32 -DDEBUGGER -DCOMPILE_V25 -DUSE_NT_SOUND_ONLY
#DFLAGS=-g4
CFLAGS=-Ic:/hugo/source -Ic:/lcc/include -Ic:/lcc/mikmod/source $(DFLAGS) $(DEFINES) -errout=output.txt
#CFLAGS=-Ic:/hugo/source -Ic:/lcc/include -Ic:/lcc/mikmod/source $(DFLAGS) $(DEFINES)
LFLAGS=-subsystem windows
LIBS=c:\lcc\jpeg\libjpeg.lib c:\lcc\mikmod\source\libmik.lib winmm.lib \
shell32.lib 

OBJS=he.$(OBJ_EXT) heexpr.$(OBJ_EXT) hemisc.$(OBJ_EXT) heobject.$(OBJ_EXT) \
heparse.$(OBJ_EXT) heres.$(OBJ_EXT) herun.$(OBJ_EXT) heset.$(OBJ_EXT) \
stringfn.$(OBJ_EXT) \
hd.$(OBJ_EXT) hddecode.$(OBJ_EXT) hdmisc.$(OBJ_EXT) hdtools.$(OBJ_EXT) \
hdupdate.$(OBJ_EXT) hdval.$(OBJ_EXT) \
$(NONPORTABLE_OBJS)

# hclcc.$(OBJ_EXT) is included to steal hugo_makepath() and hugo_splitpath()

$(TARGET).exe: $(OBJS)
	$(LINK) $(LFLAGS) -o $(TARGET) $(OBJS) $(LIBS)


# Non-portable sources with irregular include requirements:

hejpeg.$(OBJ_EXT): $(SOURCE_DIR)/hejpeg.c
	$(COMPILE) $(CFLAGS) -Ic:/lcc/jpeg $(SOURCE_DIR)/hejpeg.c

hesound.$(OBJ_EXT): $(SOURCE_DIR)/hesound.c
	$(COMPILE) $(CFLAGS) -Ic:/lcc/mikmod/source $(SOURCE_DIR)/hesound.c
