package iageclient;

import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.util.*;
import java.io.*;

public class gameframe extends Frame {
	
  private Panel pnlTop = new Panel();
  private BorderLayout borderLayout1 = new BorderLayout();
  private Label lblLocation = new Label();
  private Label lblScore = new Label();
  private Label lblStatus = new Label();
  private Panel pnlMid = new Panel();
  private mainconsole theConsole = null;
  private Displayer txttextonly = new Displayer();
  private Panel pnlBot = new Panel();
  private TextField txtinput = new TextField();
  private BorderLayout borderLayout2 = new BorderLayout();
  private BorderLayout borderLayout3 = new BorderLayout();
  private BorderLayout borderLayout4 = new BorderLayout();
  MenuBar menuBar1 = new MenuBar();
  Menu menuFile = new Menu();
  MenuItem menuFileConnect = new MenuItem();
  MenuItem menuFileSaveTranscript = new MenuItem();
  MenuItem menuFileViewScrollback = new MenuItem();
  MenuItem menuFileQuit = new MenuItem();
  Menu menuHelp = new Menu();
  MenuItem menuHelpAbout = new MenuItem();
  
  public String IP = "";
  public String Alias = "";

  private iageconnector ic = null;
  // Global connection
  
  // Determines whether a request for a score has been sent to the server this turn
  private boolean sentscore = false;

  public void connect(String IPToConnect, String salias) {

	IP = IPToConnect; 
    Alias = salias;
    
    // Connect to it
    ic = new iageconnector(txttextonly, lblLocation, lblScore, lblStatus, this, IP, Alias);
    
    // Set focus to input box
    txtinput.requestFocus();
  
  }
  
  public synchronized void allowConnect() {
  	menuFileConnect.setEnabled(true);
  }
  
  public synchronized void disallowConnect() {
  	menuFileConnect.setEnabled(false);
  }

  public gameframe() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception{
    this.setLayout(borderLayout1);
    this.setSize(new Dimension(640, 504));
    this.setTitle("IAGE Client");
    pnlTop.setLayout(borderLayout4);
    lblLocation.setText("                                                              ");
    lblScore.setText("                          ");
	 
    txtinput.addKeyListener(new gameframe_txtinput_keyAdapter(this));
    
    pnlBot.setLayout(borderLayout2);
    pnlMid.setLayout(borderLayout3);
    this.add(pnlTop, BorderLayout.NORTH);
    pnlTop.add(lblLocation, BorderLayout.CENTER);
    pnlTop.add(lblScore, BorderLayout.EAST);
    this.add(pnlBot, BorderLayout.SOUTH);
    pnlMid.add(txttextonly, BorderLayout.CENTER);
    this.add(pnlMid, BorderLayout.CENTER);
    pnlBot.add(txtinput, BorderLayout.CENTER);
    pnlBot.add(lblStatus, BorderLayout.SOUTH);
    
    menuFile.setLabel("File");
    menuFileConnect.setLabel("Connect to an IAGE Server");
    menuFileConnect.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
	    	menuFileConnect_actionPerformed(e);
	    }
	  });
    menuFileSaveTranscript.setLabel("Save Transcript");
    menuFileSaveTranscript.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
	    	menuFileSaveTranscript_actionPerformed(e);
	    }
	  });
	menuFileViewScrollback.setLabel("View Scrollback");
	menuFileViewScrollback.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
	    	menuFileViewScrollback_actionPerformed(e);
	    }
	  });
	    
    menuFileQuit.setLabel("Quit");
    menuFileQuit.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
	    	menuFileQuit_actionPerformed(e);
	    }
	  });
	  
	menuHelp.setLabel("Help");
	menuHelpAbout.setLabel("About");
	menuHelpAbout.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
	    	menuHelpAbout_actionPerformed(e);
	    }
	  });
	
	  
	menuFile.add(menuFileConnect);
	menuFile.addSeparator();
    menuFile.add(menuFileSaveTranscript);
    menuFile.add(menuFileViewScrollback);
    menuFile.addSeparator();
    menuFile.add(menuFileQuit);
    menuHelp.add(menuHelpAbout);
    menuBar1.add(menuFile);
    menuBar1.add(menuHelp);
    this.setMenuBar(menuBar1);
  }

  /**Overridden so we can exit when window is closed*/
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      cancel();
    }
  }
  
  private void cancel() {
  	
  	if (ic != null) {
  		ic.Kill();
  	}
  	dispose();

  }
  
  public void menuFileConnect_actionPerformed(ActionEvent e) {
  	// Ask the user which server they want to connect to.
  	mainconsole frame = new mainconsole(this);
    //Center the window
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension frameSize = frame.getSize();
    if (frameSize.height > screenSize.height) {
      frameSize.height = screenSize.height;
    }
    if (frameSize.width > screenSize.width) {
      frameSize.width = screenSize.width;
    }
    frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    frame.setResizable(false);
    frame.setVisible(true);
  }
  
  public void menuFileViewScrollback_actionPerformed(ActionEvent e) {
  		scrollback sb = new scrollback(ic.transcriptoutput);
  		sb.setSize(new Dimension(400, 400));
  		sb.setVisible(true);
  }

  public void menuHelpAbout_actionPerformed(ActionEvent e) {
  	mainconsole_AboutBox dlg = new mainconsole_AboutBox(this);
    Dimension dlgSize = dlg.getPreferredSize();
    Dimension frmSize = getSize();
    Point loc = getLocation();
    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    dlg.setModal(true);
    dlg.show();
  }

  public void menuFileSaveTranscript_actionPerformed(ActionEvent e) {
  	
  	FileDialog chooser = new FileDialog(this, ""); 
  	chooser.setTitle("Save As");
  	chooser.setMode(FileDialog.SAVE);
  	chooser.show();
  	
  	// Bomb now if nothing chosen
  	if (chooser.getFile().equals("")) return;
  	
	String savefilename = chooser.getDirectory() + chooser.getFile();
	// Save the transcript
	try {
		File fh = new File(savefilename);
		FileOutputStream out = new FileOutputStream(fh);
		out.write(ic.transcriptoutput.getBytes());
		out.flush();
		out.close();
	}
	catch (Exception ex) {
		ex.printStackTrace();	
	}
  }
  
  public void menuFileQuit_actionPerformed(ActionEvent e) {
  	cancel();
  }

  public void txtinput_keyPressed(KeyEvent e) {
  	
  	// Tell the displayer so any More prompt can be cleared
  	txttextonly.setIsBusy(false);
  	
    // If it's enter, transmit the text or connect
	if (e.getKeyCode() == KeyEvent.VK_ENTER) {
	
	  // If it is a special client only command, do not
	  // send it for processing - just parse it and clear the contents
	  if (txtinput.getText().startsWith("/")) {
	  	
	  	// Is it a delay command?
	  	if (txtinput.getText().indexOf("delay") != -1) {
	  		
	  		// Read the new value
	  		String txt = txtinput.getText();
	  		
	  		try {
		  		long delayval = Long.parseLong(txt.substring(txt.indexOf(" ") + 1, txt.length()));
		  		iageconnector.delayValue = delayval;
		  		ic.OutputText("Delay value set to " + Long.toString(delayval) + " milliseconds.");
		  	}
		  	catch (Exception ex) {
		  		ex.printStackTrace();	
		  	}
		  	
		  	// Finish up
		  	txtinput.setText("");
		  	return;
	  	}
	  }
	
	  // Reset the render count after enter is pressed
	  txttextonly.resetRenderCount();
	
	  String s = txtinput.getText();
	  if (s.equals("")) s = " "; // Send a space if no text - makes no odds to parser
      ic.Send(s, false);
	  /* Clear user input contents */
	  txtinput.setText("");
	  // Allow another score request to be sent
	  sentscore = false;
	}
	else
	{
	  // request a score if we haven't done it once since we cycled round
	  //if (!sentscore) {ic.Send("getscore", true); sentscore = true;}
	}
  }
}

class gameframe_txtinput_keyAdapter extends java.awt.event.KeyAdapter {
  gameframe adaptee;

  gameframe_txtinput_keyAdapter(gameframe adaptee) {
    this.adaptee = adaptee;
  }

  public void keyPressed(KeyEvent e) {
    adaptee.txtinput_keyPressed(e);
  }
}


class mainconsole_AboutBox extends Dialog implements ActionListener {

  Panel panel1 = new Panel();
  Panel panel2 = new Panel();
  Panel insetsPanel1 = new Panel();
  Panel insetsPanel2 = new Panel();
  Panel insetsPanel3 = new Panel();
  Button button1 = new Button();
  Label imageLabel = new Label();
  Label label1 = new Label();
  Label label2 = new Label();
  Label label3 = new Label();
  Label label4 = new Label();
  BorderLayout borderLayout1 = new BorderLayout();
  BorderLayout borderLayout2 = new BorderLayout();
  FlowLayout flowLayout1 = new FlowLayout();
  GridLayout gridLayout1 = new GridLayout();
  String product = "Internet Adventure Game Engine Client";
  String version = iageconnector.Version;
  String copyright = "Copyright (c) 2000-2002, R.Rawson-Tetley";
  String comments = "http://iage.homeip.net";
  
  /** Constructs a new about box. Requires a Frame parent. */
  public mainconsole_AboutBox(Frame parent) {
    super(parent);
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
    pack();
  }
  
  private void jbInit() throws Exception  {
    this.setTitle("About");
    setResizable(false);
    panel1.setLayout(borderLayout1);
    panel2.setLayout(borderLayout2);
    insetsPanel1.setLayout(flowLayout1);
    insetsPanel2.setLayout(flowLayout1);
    gridLayout1.setRows(4);
    gridLayout1.setColumns(1);
    label1.setText(product);
    label2.setText(version);
    label3.setText(copyright);
    label4.setFont(new java.awt.Font("Dialog", 1, 12));
    label4.setForeground(Color.blue);
    label4.setText(comments);
    insetsPanel3.setLayout(gridLayout1);
    button1.setLabel("Ok");
    button1.addActionListener(this);
    insetsPanel2.add(imageLabel, null);
    panel2.add(insetsPanel2, BorderLayout.WEST);
    this.add(panel1, null);
    insetsPanel3.add(label1, null);
    insetsPanel3.add(label2, null);
    insetsPanel3.add(label3, null);
    insetsPanel3.add(label4, null);
    panel2.add(insetsPanel3, BorderLayout.CENTER);
    insetsPanel1.add(button1, null);
    panel1.add(insetsPanel1, BorderLayout.SOUTH);
    panel1.add(panel2, BorderLayout.NORTH);
  }
  /**Overridden so we can exit when window is closed*/
  protected void processWindowEvent(WindowEvent e) {
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      cancel();
    }
    super.processWindowEvent(e);
  }
  /**Close the dialog*/
  void cancel() {
    dispose();
  }
  /**Close the dialog on a button event*/
  public void actionPerformed(ActionEvent e) {
    if (e.getSource() == button1) {
      cancel();
    }
  }
}