package iagecompiler;

/**
 * Character class - represents details of one IAGE Non-Player Character
 */

public class character {

  /** Character's ID */
  public long ID = 0;
  /** Display name of character */
  public String Name = "";
  public String CodeName = "";
  /** Character's current location */
  public long CurrentLocation = 0;
  /** Description to use before NPC has moved from initial location (replaces Name) */
  public String Description = "";
  /** Flag to determine whether NPC has moved from where it started */
  public boolean MovedFromOriginalLocation = false;
  /** Default description when examining the NPC */
  public String DefaultExamine = "";
  /** Noun ID for referring to NPC */
  public long NounID = 0;
  /** Timer interval in milliseconds before OnTimer event runs */
  public long TimerInterval = 0;
  /** Number of timer events that have run */
  public long TimerIndex = 0;
  /** Time next OnTimer event will run */
  public long TimeToNextRun = 0;
  /** AI Mode NPC is currently in. System AI is only implemented as
   *  locational movement. All other AI must be scripted using the
   *  OnTimer event.
   *
   *  character.NONE (0) for no action
   *  character.FOLLOWPLAYER (1) for following a particular player
   *  character.RANDOM (2) for moving around the map at random.
   */
  public byte AIMode = 0;
  /** Constant for no NPC AI movement */
  public static byte NONE = 0;
  /** Constant for following player AI movement */
  public static byte FOLLOWPLAYER = 1;
  /** Constant for random map AI movement */
  public static byte RANDOM = 2;
  /** Constant for attacking */
  public static byte ATTACKING = 3;
  /** Unique identifier (Index) of player this NPC is following */
  public long FollowPlayerIndex = 0;
  /** Custom properties string. Custom properties tie together flags and objects */
  public String CustomProperties = "";
  /** Hit points the NPC has */
  public long HitPoints = 0;
  /** Maximum amount of damage NPC can do */
  public long DamageIndicator = 0;
  /** Money carried by NPC */
  public long Money = 0;
  /** If IAGE combat is on, cause this NPC to attack any players in the location */
  public boolean AutoAttack = false;
  /** If IAGE combat is on, cause this NPC to fight when people attack them */
  public boolean AttackWhenAttacked = false;
  /** Contains the index of the player this NPC is attacking */
  public int AttackingWho = 0;
  /** Code collection which fires when the NPC is referenced */
  public iagecode OnAction = new iagecode();
  /** Code collection which fires when the NPC is spoken to 
    * (a player starts their input with <npcname><comma><string>
    */
  public iagecode OnTalk = new iagecode();
  /** Code collection which fires when the timer's interval has elapsed */
  public iagecode OnTimer = new iagecode();
  
}