package iagecompiler;

import java.awt.event.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;


/** My code entry class which allows autocompleting etc, with a handy
    popup list.*/
public class codeentry extends JPanel {
	
	private BorderLayout layman = new BorderLayout();
	private JTextArea thetext = new JTextArea();
	private JScrollPane scrthetext = new JScrollPane();
	private JList codecomplete = new JList();
	private JScrollPane scrcodecomplete = new JScrollPane();
	
	public codeentry() {
		
		// Draw it
		thetext.setFont(new Font("monospaced", Font.PLAIN, 12));
		thetext.addKeyListener(new KeyAdapter() {
			public void keyPressed(KeyEvent e) {
				thetext_keyPressed(e);
			}
		});
		this.setLayout(layman);
		codecomplete.setFixedCellWidth(150);
		scrcodecomplete.setVisible(false);
		scrthetext.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
    	scrthetext.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
    	scrthetext.getViewport().add(thetext, null);
    	scrcodecomplete.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
    	scrcodecomplete.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
    	scrcodecomplete.getViewport().add(codecomplete, null);
    	codecomplete.addMouseListener(new MouseAdapter() {
    	public void mouseClicked(MouseEvent e) {
    		if (e.getClickCount() == 2) {
    			codecomplete_mouseclicked(e);
    		}
    	}
      });
    	
		this.add(scrthetext, BorderLayout.CENTER);
		this.add(scrcodecomplete, BorderLayout.EAST);
		
	}
	
	// Facilities for getting and setting text
	public void setText(String newtext) {
		thetext.setText(newtext);	
	}
	
	public String getText() {
		return thetext.getText();	
	}
	
	public void thetext_keyPressed(KeyEvent e) {
	
		// Use this for filling the code complete:
		
		// A full-stop pressed - find the object
		// and load the appropriate method
		// calls into the list.
		
		if (e.getKeyCode() == KeyEvent.VK_PERIOD) {
			
			int pos = thetext.getCaretPosition();
			String s = thetext.getText();
			
			// Count backwards until we find a space, a tab
			// or a line break
			int i = pos - 1;
			while (i > 0) {	
				String curchar = s.substring(i, i + 1);
				if (curchar.equals(" ") || curchar.equals("\t") || curchar.equals("\n")) {
					break;
				}			
				i--;
			}
			String obj = s.substring(i + 1, pos);
			
			// obj should now hold our object call - let's
			// see what it is and fill our list.
			
			// INPUT OBJECT
			// ================================================
			
			if (obj.startsWith("input")) {
			
				String[] datar = {"verb", "verb2", "verb3", 
								  "noun", "noun2", "noun3", 
								  "adverb", "adverb2", "adverb3"};
				codecomplete.setListData(datar);
				scrcodecomplete.setVisible(true);
				this.paintAll(this.getGraphics());
				return;
			}
			
			// ARRAY OBJECT
			// ================================================
			
			if (obj.startsWith("array")) {
			
				String[] datar = {"new <name> <itemlist>", "add <name> <itemexpr>", "get <name> <no>", 
								  "set <name> <no> <value>", "remove <name> <itemexpr>", "getcount(<name>)"
								  };
				codecomplete.setListData(datar);
				scrcodecomplete.setVisible(true);
				this.paintAll(this.getGraphics());
				return;
			}
			
			// GAME OBJECT
			// ================================================
			if (obj.startsWith("game")) {
				
				String[] datar = {"displaycurrentlocation", "displayversion", "getinventory <locationid>"};
				codecomplete.setListData(datar);
				scrcodecomplete.setVisible(true);
				this.paintAll(this.getGraphics());
				return;
			}
			
			// INTERNAL OBJECT
			// ================================================
			if (obj.startsWith("internal")) {
				
				String[] datar = {"attackplayer <playerindex>", "attacknpc <npcid>",
								  "close <itemid>", "drop <itemid>", "eat <itemid>",
								  "examine <itemid>", "extinguish <itemid>", "get <itemid>",
								  "getin <itemid>", "getoutof <itemid>", "go <direction>",
								  "inventory", "lieon <itemid>", "light <itemid>", "open <itemid>",
								  "put <itemid> in <itemid>", "read <itemid>", "remove <itemid> from <itemid>",
								  "siton <itemid>", "stand", "unwear <itemid>", "wear <itemid>"
				};

				codecomplete.setListData(datar);
				scrcodecomplete.setVisible(true);
				this.paintAll(this.getGraphics());
				return;
			}
			
			// ITEM OBJECT
			// ================================================
			if (obj.startsWith("item")) {
				
				String[] datar = {"count", "id", "name", "currentlocation", "description",
				"defaultexamine", "weight", "containedweight", "size", "containedsize",
				"islightsource", "islit", "iswearable", "isworn", "invisible", "iscontainer",
				"isweapon", "isfixed", "fixedmessage", "hassurface", "canbestoodon",
				"canbesaton", "canbelaidon", "canopenclose", "openclosestate", "isedible",
				"ediblehitpoints", "isreadable", "readabletext", "issubitem", "damageindicator",
				"movedfromoriginallocation",
				"getuserboolean(<name>)", "adduserboolean(<name>)", "removeuserboolean(<name>)",
				"getvalue(<name>)", "setvalue(<name>)"
				};
				
				codecomplete.setListData(datar);
				scrcodecomplete.setVisible(true);
				this.paintAll(this.getGraphics());
				return;
			}
			
			// LOCATION OBJECT
			// ================================================
			if (obj.startsWith("location")) {
				
				String[] datar = {"count", "id", "name", "imagepath", "description", "isdark",
				"n", "s","e","w","u","d","ne","nw","se","sw", "getvalue(<name>)", "setvalue(<name>)"
				};
				
				codecomplete.setListData(datar);
				scrcodecomplete.setVisible(true);
				this.paintAll(this.getGraphics());
				return;
			}
			
			// FLAG OBJECT
			// ================================================
			if (obj.startsWith("flag")) {
				
				String[] datar = {"count", "value"
				};
				
				codecomplete.setListData(datar);
				scrcodecomplete.setVisible(true);
				this.paintAll(this.getGraphics());
				return;
			}
			
			// MESSAGE OBJECT
			// ================================================
			if (obj.startsWith("message")) {
				
				String[] datar = {"count", "id", "text", "show", "showothers", "showallin <locationid>"
				};
				
				codecomplete.setListData(datar);
				scrcodecomplete.setVisible(true);
				this.paintAll(this.getGraphics());
				return;
			}
			
			// CHARACTER OBJECT
			// ================================================
			if (obj.startsWith("character")) {
				
				String[] datar = {"count", "id", "name",
				"currentlocation", "hitpoints", "damageindicator", "money",
				"autoattack", "attackwhenattacked", "description", "defaultexamine",
				"nounid", "timerinterval", "timerindex", "timetonextrun",
				"movedfromoriginallocation", "aimode", "followplayerindex", "getvalue(<name>)", "setvalue(<name>)"};
				
				codecomplete.setListData(datar);
				scrcodecomplete.setVisible(true);
				this.paintAll(this.getGraphics());
				return;
			}
			
			// PLAYER OBJECT
			// ================================================
			if (obj.startsWith("player") || obj.startsWith("playerarray") || obj.startsWith("currentplayer")) {
				
				String[] datar = {"count", "index", "name",
				"score", "turns", "currentlocation", "ipaddress", "cansee", "textonly", "outputtoplayer",
				"state", "stateitem", "lastnoun", "lastcommand", "weightcarried",
				"itemscarried", "sizecarried", "verbosemode", "hitpoints", "damageindicator",
				"chanceofhitting", "money", "cp<x>",
				"quit", "showscore", "showstatus", "print <expr>", "getfirstboolitem(<boolean>)",
				"dropallitems", "iscarrying(<itemid>)",
				"savestate <identifier> <password>",
				"restorestate <identifier> <password>",
				"getvalue(<name>)", "setvalue(<name>)"
				
				};
				
				codecomplete.setListData(datar);
				scrcodecomplete.setVisible(true);
				this.paintAll(this.getGraphics());
				return;
			}

			// NO OBJECT FOUND
			// ================================================
			String[] blnk = {""};
			codecomplete.setListData(blnk);
			scrcodecomplete.setVisible(false);
			this.paintAll(this.getGraphics());
						
		}
		else
		{
			String[] blnk = {""};
			codecomplete.setListData(blnk);
			scrcodecomplete.setVisible(false);
			this.paintAll(this.getGraphics());
		}
	}
	
	public void codecomplete_mouseclicked(MouseEvent e) {
	
		// Insert the text of the selected item 
		// in (if there is one):
		if (codecomplete.getSelectedIndex() < 0) return;
		
		// Get the value
		String si = (String) codecomplete.getSelectedValue();
		
		// Shove it in:
		thetext.insert(si, thetext.getCaretPosition());
		
	}
}