package iageinteractive;

import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;

/**
 * Frame class used to display all objects to coder
 */
public class startup extends Frame {
	
  private boolean dataloaded = false;
	
  /* Control tree:
  
  	contentPane (borderlayout)
  		txtoutput
  
  */
	
  private MenuBar jMenuBar1 = new MenuBar();
  private Menu jMenuFile = new Menu();
  private MenuItem jMenuFileCompile = new MenuItem();
  private MenuItem jMenuFileSave = new MenuItem();
  private MenuItem jMenuFileSaveIAGE = new MenuItem();
  private MenuItem jMenuFileSaveInform = new MenuItem();
  private MenuItem jMenuFileTest = new MenuItem();
  private MenuItem jMenuFileExit = new MenuItem();
  private Menu jMenuHelp = new Menu();
  private MenuItem jMenuHelpAbout = new MenuItem();
  
  private BorderLayout borderLayout = new BorderLayout();
  private TextArea txtoutput = new TextArea();
  
  private String curdir = ""; // Holds the last directory accessed
  
  /**Constructs a new server output window and displays it */
  public startup() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  
  public static void main(String Args[]) {
  	
  		startup st = new startup();
  		st.setSize(640, 480);
  		st.setVisible(true);
  }
  
  /**Component initialization*/
  private void jbInit() throws Exception  {
  	
    this.setLayout(borderLayout);
    this.setSize(new Dimension(760, 480));
    this.setTitle("Interaction Compiler - IAGE");
  	
  	
  	// menubar
    jMenuFile.setLabel("File");
    jMenuFileCompile.setLabel("Compile");
    
    jMenuFileCompile.setLabel("Compile");
    jMenuFileCompile.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
      	jMenuFileCompile_actionPerformed(e);
      }
  	});
  	jMenuFileSaveIAGE.setLabel("Save IAGE Code");
  	jMenuFileSaveIAGE.setEnabled(true);
  	jMenuFileSaveIAGE.addActionListener(new ActionListener() {
  		public void actionPerformed(ActionEvent e) {
  			jMenuFileSaveIAGE_actionPerformed(e);
  		}
  	});
  	jMenuFileSaveInform.setLabel("Save Inform Code");
  	jMenuFileSaveInform.setEnabled(false);
  	/*jMenuFileSaveInform.addActionListener(new ActionListener() {
  		public void actionPerformed(ActionEvent e) {
  			jMenuFileSaveInform_actionPerformed(e);
  		}
  	});*/
  	jMenuFileTest.setLabel("Test");
  	jMenuFileTest.setEnabled(true);
  	jMenuFileTest.addActionListener(new ActionListener() {
  		public void actionPerformed(ActionEvent e) {
  			jMenuFileTest_actionPerformed(e);
  		}
  	});
    jMenuFileExit.setLabel("Exit");
    jMenuFileExit.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuFileExit_actionPerformed(e);
      }
    });
    
    jMenuHelp.setLabel("Help");
    jMenuHelpAbout.setLabel("About");
    jMenuHelpAbout.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuHelpAbout_actionPerformed(e);
      }
    });
    ;
    jMenuFile.add(jMenuFileCompile);
    jMenuFile.addSeparator();
    jMenuFile.add(jMenuFileSaveIAGE);
    jMenuFile.add(jMenuFileSaveInform);
    jMenuFile.addSeparator();
    jMenuFile.add(jMenuFileTest);
    jMenuFile.addSeparator();
    jMenuFile.add(jMenuFileExit);
    
    
    jMenuHelp.add(jMenuHelpAbout);
    
    jMenuBar1.add(jMenuFile);
    jMenuBar1.add(jMenuHelp);
    this.setMenuBar(jMenuBar1);

	// Controls
    this.add(txtoutput, BorderLayout.CENTER);
    txtoutput.setEditable(false);
    txtoutput.append("Internet Adventure Game Engine Interaction Compiler " + vdu.versionno + "\nCopyright(c)2001, R.Rawson-Tetley.\n");
 
 	// References
    vdu.console = txtoutput;

  }
  
  /**File | Compile action performed*/
  public void jMenuFileCompile_actionPerformed(ActionEvent e) {
  	new importint().doimport(this);
  	jMenuFileSave.setEnabled(true);
  	jMenuFileSaveIAGE.setEnabled(true);
  }
  
  /**File | Exit action performed*/
  public void jMenuFileExit_actionPerformed(ActionEvent e) {
    dispose();
  }
  
  /**File | SaveIAGE action performed */
  public void jMenuFileSaveIAGE_actionPerformed(ActionEvent e) {

		saveiage si = new saveiage();
		si.save(this);
		
  }
  
  /**File | SaveInform action performed */
  public void jMenuFileSaveInform_actionPerformed(ActionEvent e) {
		/*saveiage si = new saveinform();
		si.save();*/
  }
  
  public void jMenuFileTest_actionPerformed(ActionEvent e) {
  		tester te = new tester();
  		te.setSize(640, 480);
  		te.setVisible(true);
  }
  
  /**Help | About action performed*/
  public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
    mainframe_AboutBox dlg = new mainframe_AboutBox(this);
    Dimension dlgSize = dlg.getPreferredSize();
    Dimension frmSize = getSize();
    Point loc = getLocation();
    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    dlg.setModal(true);
    dlg.show();
  }
 
  /*** Writes a line of text to the outputstream specified */
  private void writeline(FileOutputStream out, String s) {
  	
  	byte[] ba = s.getBytes();
  	try {
  		out.write(ba);
  		// Dump a Windows type carriage return - it's a bytestream, who cares!
  		// The read process looks for Windows type carriage returns anyway
  		byte[] bb = { 13, 10 };
  		out.write(bb);
  	}
  	catch (Exception e) {
  		e.printStackTrace();
  		vdu.println("Error writing to file - " + e.getMessage());
  	}
  	
  }
 
   private String readline(FileInputStream fs) {
    // Reads a complete line of data from a file, throwing away the
    // Chr(13) and Chr(10)s.
    StringBuffer sb = new StringBuffer("");
    Integer iob;
    int nb = -1;
    //byte[] by;

    while (true) {

      // Read next byte from stream
      try {
        nb = fs.read();
      }
      catch(Exception e) {
        vdu.println("Error reading from file - " + e.getMessage());
        return sb.toString();
      }

      // if it's a -1 or a 13, better quit and return
      if (nb == 13) {
        try {
          nb = fs.read(); // ditch the chr(10) as well
        }
        catch(Exception e) {
          vdu.println("Error reading from file - " + e.getMessage());
          return sb.toString();
        }
        return sb.toString();
      }

      if (nb == -1) {
        // no more data - return what we have
        return sb.toString();
      }

      // Otherwise, append our jobbie into the string buffer
      iob = new Integer(nb);
      byte[] by = { iob.byteValue()};
      sb.append(new String(by));

    }

  }
   
  /**Overridden so frame can destroy itself when window is closed*/
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      	jMenuFileExit_actionPerformed(null);
    }
  }
  
}