/**
 * IAGE Server Applet
 * R.Rawson-Tetley, 25/10/2001
 */

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import iageserver.*;


public class IAGEServPlet extends Applet {
	
	private iageconnector ic;
	private boolean sentscore = false;
	
	private BorderLayout bl = new BorderLayout();
	private BorderLayout pl = new BorderLayout();
	private BorderLayout pl2 = new BorderLayout();
	private Label title = new Label("Loading...");
	private Label score = new Label("IAGE ServPlet, Written by R.Rawson-Tetley.");
	private Label status = new Label();
	private Panel header = new Panel();
	private Panel footer = new Panel();
	private Displayer outwindow = new Displayer();
	private TextField inp = new TextField();
	private PreOutput pre = null;
	
	public void init() {
		
		inp.addKeyListener(new ikl(this));
		inp.setEnabled(false);
		
		header.setLayout(pl);
		header.add(title, BorderLayout.CENTER);
		header.add(score, BorderLayout.EAST);
		
		footer.setLayout(pl2);
		footer.add(inp, BorderLayout.CENTER);
		footer.add(status, BorderLayout.SOUTH);
		
		this.setLayout(bl);
		this.add(header, BorderLayout.NORTH);
		this.add(outwindow, BorderLayout.CENTER);
		this.add(footer, BorderLayout.SOUTH);

		// Get the host to connect to and default player names
		String gamefile = this.getParameter("GameFile");
		String pname = this.getParameter("DefaultPlayerName");
		
		// Create new pre-outputter
		pre = new PreOutput(outwindow, status);
		pre.start();

		// Set vdu
		vdu.out = pre;

		// Force painting
		this.repaint();
		this.paintComponents(this.getGraphics());
		
		// Create the connector
		ic = new iageconnector(pre, title, score, inp, pname);

		// Connect and load the game file in a new thread
		data d = new data();
		d.absoluteurl = gamefile;
		d.theconnector = ic;
		d.start();

	}
	
	public void inp_keyPressed(KeyEvent e) {
		
		// Tell the displayer so any More prompt can be cleared
  		outwindow.setIsBusy(false);
		
		// If it's enter, transmit the text or connect
		if (e.getKeyCode() == KeyEvent.VK_ENTER) {
			
			// Reset the render count after enter is pressed
	  		outwindow.resetRenderCount();
			
			String s = inp.getText();
			if (s.equals("")) s = " "; // Send a space if no text - makes no odds to parser
			
			pre.Output("<br><br>--> " + s + "<br>");
			
			processor pr = new processor(s + ".getscore", ic.thisplayer);
			/* Clear user input contents */
			inp.setText("");
		}
	}

}

class ikl extends java.awt.event.KeyAdapter {
  IAGEServPlet adaptee;
  ikl(IAGEServPlet adaptee) {
    this.adaptee = adaptee;
  }
  public void keyPressed(KeyEvent e) {
    adaptee.inp_keyPressed(e);
  }
}
