package iageserver;

import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;

/**
 * Frame class used to display server output to the
 * server user.
 */
public class mainframe extends Frame {
    
    /**
     *
     * Control tree:
     *
     * contentPane
     * borderLayout1
     * txtOut (CENTER)
     * pnlPlay (EAST)
     * borderLayout2
     * btnKill (SOUTH)
     * lblCon (NORTH)
     * lstp (CENTER)
     *
     */
    
    // Window
    private Panel contentPane;
    private BorderLayout borderLayout1 = new BorderLayout();
    // Menu
    private MenuBar jMenuBar1 = new MenuBar();
    private Menu jMenuFile = new Menu();
    private MenuItem jMenuFileOpen = new MenuItem();
    private MenuItem jMenuFileExit = new MenuItem();
    private Menu jMenuServer = new Menu();
    private MenuItem jMenuServerStartServer = new MenuItem();
    private MenuItem jMenuServerStopServer = new MenuItem();
    private Menu jMenuHelp = new Menu();
    private MenuItem jMenuHelpAbout = new MenuItem();
    // text pane
    private TextArea txtout = new TextArea();
    // Connection list and kill button
    private java.awt.List lstp = new java.awt.List();
    private Panel pnlplay = new Panel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private Button btnKillPlayer = new Button();
    private Label lblConn = new Label();
    
    private String curdir = ""; // Holds the last directory accessed
    
    private Server theServer = null;
    
    /**Constructs a new server output window and displays it */
    public mainframe(Server s) {
        try {
            enableEvents(AWTEvent.WINDOW_EVENT_MASK);
            jbInit();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
        theServer = s;
    }
    
    /**Component initialization*/
    private void jbInit() throws Exception  {
        
        // Top-level window
        
        this.setLayout(borderLayout1);
        this.setSize(new Dimension(640, 480));
        this.setTitle("Server - IAGE");
        
        // Menubar
        
        jMenuFile.setLabel("File");
        jMenuFileOpen.setLabel("Load IAGE Game File");
        jMenuFileOpen.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jMenuFileOpen_actionPerformed(e);
            }
        });
        jMenuFileExit.setLabel("Exit");
        jMenuFileExit.addActionListener(new ActionListener()  {
            public void actionPerformed(ActionEvent e) {
                jMenuFileExit_actionPerformed(e);
            }
        });
        jMenuServer.setLabel("Server");
        jMenuServerStartServer.setLabel("Start Server");
        jMenuServerStartServer.setEnabled(false);
        jMenuServerStartServer.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jMenuServerStartServer_actionPerformed(e);
            }
        });
        jMenuServerStopServer.setLabel("Stop Server");
        jMenuServerStopServer.setEnabled(false);
        jMenuServerStopServer.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                jMenuServerStopServer_actionPerformed(e);
            }
        });
        jMenuHelp.setLabel("Help");
        jMenuHelpAbout.setLabel("About");
        jMenuHelpAbout.addActionListener(new ActionListener()  {
            public void actionPerformed(ActionEvent e) {
                jMenuHelpAbout_actionPerformed(e);
            }
        });
        jMenuFile.add(jMenuFileOpen);
        jMenuFile.addSeparator();
        jMenuFile.add(jMenuFileExit);
        jMenuServer.add(jMenuServerStartServer);
        jMenuServer.add(jMenuServerStopServer);
        jMenuHelp.add(jMenuHelpAbout);
        jMenuBar1.add(jMenuFile);
        jMenuBar1.add(jMenuServer);
        jMenuBar1.add(jMenuHelp);
        this.setMenuBar(jMenuBar1);
        
        // Text pane
        txtout.setForeground(Color.blue);
        txtout.setBackground(Color.white);
        txtout.setEditable(false);
        
        // Scrollbar
        this.add(txtout, BorderLayout.CENTER);
        
        // Connection list, kill button in separate panel
        lblConn.setText("Connections:");
        btnKillPlayer.setLabel("Kill Player");
        btnKillPlayer.addActionListener(new mainframe_btnKillPlayer_actionAdapter(this));
        pnlplay.setLayout(borderLayout2);
        pnlplay.add(lstp, BorderLayout.CENTER);
        pnlplay.add(btnKillPlayer, BorderLayout.SOUTH);
        pnlplay.add(lblConn, BorderLayout.NORTH);
        this.add(pnlplay, BorderLayout.EAST);
        
        // Set output reference in vdu object
        vdu.out = txtout;
        vdu.connectionlist = lstp;
        
        //Center the window
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.setVisible(true);
        
    }
    /**File | Exit action performed*/
    public void jMenuFileExit_actionPerformed(ActionEvent e) {
        dispose();
    }
    /**File | Open Game action performed*/
    public void jMenuFileOpen_actionPerformed(ActionEvent e) {
        
        // Retrieve what our last file path used was:
        String loadpath = new File("").getAbsolutePath() + File.separator + "lastpath.ini";
        try {
            File ourpath = new File(loadpath);
            FileInputStream in = new FileInputStream(ourpath);
            curdir = readline(in);
            in.close();
        }
        catch (IOException ie) {
            // Ignore
        }
        
        // Prompt for a file
        FileDialog chooser = new FileDialog(this, curdir);
        chooser.setTitle("Select an IAGE game file to load");
        chooser.show();
        
        if(chooser.getFile().equals("") || chooser.getFile().equals(null)) return;
        
        // Save the path of the file chosen
        // in the user's profile directory in a file
        // called "lastpath.ini"
        curdir = chooser.getDirectory();
        String savepath = new File("").getAbsolutePath() + File.separator + "lastpath.ini";
        try {
            File lastpath = new File(savepath);
            FileOutputStream out = new FileOutputStream(lastpath);
            writeline(out, curdir);
            out.close();
        }
        catch (IOException ie)
        {}
        
        startupclass.startup(chooser.getDirectory() + chooser.getFile());
        // Activate menu items.
        jMenuServerStartServer.setEnabled(true);
        jMenuServerStopServer.setEnabled(false);
    }
    
    public void loadGameFile(String filename) {
        startupclass.startup(new File("").getAbsolutePath() + File.separator + filename);
        // Activate menu items.
        jMenuServerStartServer.setEnabled(true);
        jMenuServerStopServer.setEnabled(false);
    }
    
    /**Server | Start Server action performed */
    public void jMenuServerStartServer_actionPerformed(ActionEvent e) {
         // Deactivate menu items - we're running a server now!
        jMenuServerStartServer.setEnabled(false);
        jMenuServerStopServer.setEnabled(true);
        jMenuFileOpen.setEnabled(false);
        theServer.startServer();
    }
    

    
    /**Server | Stop Server action performed */
    public void jMenuServerStopServer_actionPerformed(ActionEvent e) {
        // Reactivate menu items.
        jMenuServerStartServer.setEnabled(true);
        jMenuServerStopServer.setEnabled(false);
        jMenuFileOpen.setEnabled(true);
        theServer.stopServer();
    }
    

    
    /**Help | About action performed*/
    public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
        mainframe_AboutBox dlg = new mainframe_AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = getSize();
        Point loc = getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.show();
    }
    
    /** KillPlayer button pressed */
    public void btnKillPlayer_actionPerformed(ActionEvent e) {
        
        // Don't do anything if we don't have any connections
        if (lstp.getSelectedIndex() == -1) return;
        
        String si = (String) lstp.getItem(lstp.getSelectedIndex());
        si = si.substring(0, si.indexOf(":"));
        int idx = Integer.parseInt(si);
        
        int i = 1;
        player p = null;
        
        while (i <= data.oplayers.getCount()) {
            p = (player) data.oplayers.get(i);
            if (p.Index == idx) {
                // Tell player
                vdu.Transmit("Your socket was deliberately killed by the server operative.", p);
                // Stop listening and close
                p.quit(true);
                return;
            }
            i++;
        }
        
    }
    
    /*** Writes a line of text to the outputstream specified */
    private void writeline(FileOutputStream out, String s) {
        
        byte[] ba = s.getBytes();
        try {
            out.write(ba);
            // Dump a Windows type carriage return - it's a bytestream, who cares!
            // The read process looks for Windows type carriage returns anyway
            byte[] bb = { 13, 10 };
            out.write(bb);
        }
        catch (Exception e) {
            e.printStackTrace();
            vdu.println("Error writing to file - " + e.getMessage());
        }
        
    }
    
    private String readline(FileInputStream fs) {
        // Reads a complete line of data from a file, throwing away the
        // Chr(13) and Chr(10)s.
        StringBuffer sb = new StringBuffer("");
        Integer iob;
        int nb = -1;
        //byte[] by;
        
        while (true) {
            
            // Read next byte from stream
            try {
                nb = fs.read();
            }
            catch(Exception e) {
                vdu.println("Error reading from file - " + e.getMessage());
                return sb.toString();
            }
            
            // if it's a -1 or a 13, better quit and return
            if (nb == 13) {
                try {
                    nb = fs.read(); // ditch the chr(10) as well
                }
                catch(Exception e) {
                    vdu.println("Error reading from file - " + e.getMessage());
                    return sb.toString();
                }
                return sb.toString();
            }
            
            if (nb == -1) {
                // no more data - return what we have
                return sb.toString();
            }
            
            // Otherwise, append our jobbie into the string buffer
            iob = new Integer(nb);
            byte[] by = { iob.byteValue()};
            sb.append(new String(by));
            
        }
        
    }
    
    /**Overridden so frame can destroy itself when window is closed*/
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == WindowEvent.WINDOW_CLOSING) {
            // Stop the admin thread
            theServer.killAdminThread();
            // Stop the server if we have one running:
            if (theServer.serverisrunning) {jMenuServerStopServer_actionPerformed(null);}
            // Exit
            jMenuFileExit_actionPerformed(null);
        }
    }
}

class mainframe_btnKillPlayer_actionAdapter implements java.awt.event.ActionListener {
    mainframe adaptee;
    
    mainframe_btnKillPlayer_actionAdapter(mainframe adaptee) {
        this.adaptee = adaptee;
    }
    
    public void actionPerformed(ActionEvent e) {
        adaptee.btnKillPlayer_actionPerformed(e);
    }
}