package iageserver;

import java.net.*;
import java.io.*;

/**
 * Player class - holds information about an IAGE human player.
 */
public class player {

	/** Player's selected alias. */
	public String Name = "";
	/** Display name */
	public String DisplayName = "";
	/** Player score.*/
	public long Score = 0;
	/** Player turns taken */
	public long Turns = 0;
	/** Player current location */
	public long CurrentLocation = 0;
	/** Player IP Address */
	public String IPAddress = "";
	/** Player unique index */
	public int Index = 0;
	/** Player's current state */
	public byte State = player.ST_NORMAL;
	/** Object item player's state is affecting (lying, sitting or stood on) */
	public item StateItem = null;
	/** Total weight carried by this player. */
	public long WeightCarried = 0;
	/** Total number of items carried by this player */
	public long ItemsCarried = 0;
	/** Total size of items carried by this player */
	public long SizeCarried = 0;
	/** Last noun ID player used (used for "it" in parser). */
	public long LastNoun = 0;
	public String LastNounText = "";
	/** Player can see? Not in dark location with no lightsource? */
	public boolean CanSee = true;
	/** Last input from player (used for "again" in parser). */
	public String LastCommand = "";
	/** Combined list of location IDs this player has visited. */
	public iagecollection LocationsSeen = new iagecollection();
	/** Whether room descriptions should be repeated to this player for locations the have already visited */
	public boolean VerboseMode = true;
	/** Reference to IP Socket this player is connected on. */
	public Socket PlayerSocketHandle = null;
	/** Reference to input stream on player socket */
	public DataInputStream socket_inputstream = null;
	/** Reference to output stream on player socket */
	public PrintWriter socket_outputstream = null;
	/** Reference to serverlistenthread class being used by this player */
	public serverlistenthread serverthread = null;
	/** Flag used to determine whether the player has been transmitted something recently */
	public boolean OutputToPlayer = false;
	/** Number of hit points the player has */
	public long HitPoints = 0;
	/** Maximum number of hit points player can take without a weapon */
	public long DamageIndicator = 0;
	/** Money carried by the player */
	public long Money = 0;
	/** Chance of hitting a target in an attack expressed as a percentage */
	public long ChanceOfHitting = 60;
	/** Name value pairs */
  	public iagecollection NameValues = new iagecollection();
	/** Custom player properties - can be persisted */
	public String CP1 = "";
	public String CP2 = "";
	public String CP3 = "";
	public String CP4 = "";
	public String CP5 = "";
	public String CP6 = "";
	public String CP7 = "";
	public String CP8 = "";
	public String CP9 = "";
	public String CP10 = "";
	public String CP11 = "";
	public String CP12 = "";
	public String CP13 = "";
	public String CP14 = "";
	public String CP15 = "";
	public String CP16 = "";
	public String CP17 = "";
	public String CP18 = "";
	public String CP19 = "";
	public String CP20 = "";
	public String CP21 = "";
	public String CP22 = "";
	public String CP23 = "";
	public String CP24 = "";
	public String CP25 = "";
	public String CP26 = "";
	public String CP27 = "";
	public String CP28 = "";
	public String CP29 = "";
	public String CP30 = "";
	
	/*** Variables used by ask command */
	public int AskProgramCounter = 0;
	public String UserResponseToAsk = "";
	public boolean WaitingForAskResponse = false;
	public iagecode AskCode = null;
	public String AskCodeSource = "";
	public interpreter AskInterpreter = null;
	
	/*** Variables used by parser questions to player */
	public boolean LastParserAskedQuestion = false;
	public parsestring LastParser = null;
	/*** Number of noun to be replaced when answering question -
	     1, 2 or 3 */
	public int LastQReplacesNoun = 0;
	
	/*** Constants for player states */
	public static byte ST_NORMAL = 1;
	public static byte ST_SITTING = 2;
	public static byte ST_LYING = 3;
	public static byte ST_STOODON = 4;
	public static byte ST_INSIDE = 5;
	
	/**
	 *  Whether we are operating in text only mode.
	 */
	public boolean TextOnly = false;
	
	public void quit(boolean doitquietly) {
		
		// Run the game.onquit code
		interpreter ti = new interpreter(this, null);
		ti.runcode(data.ogame.OnQuit, "Game.OnQuit");
		
		// Inform the other players if this player had a name
		// other than the default name held in data.defaultplayername.
		if (!doitquietly) vdu.TransmitAll(processor.smake(message.getMessage(constant.MSG_PLAYERQUIT), Name));
		
		// Output to the server console that the connection has been freed.
		vdu.println("Connection " + Integer.toString(this.Index) + " - " + this.Name + " (" + this.IPAddress + ") has quit.");
		
		// Tell the player's client that it should stop it right now
		vdu.Transmit("QUIT: DIE|", this);
		
		// Make this player drop all the objects they were carrying into
		// the location they were last in.
		item.MoveAll(Index + location.PLAYERBASE, CurrentLocation);
		
		// Tell everyone
		if (!doitquietly) vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_PLAYERDROPSTHEIROBJECTS), Name), this, this.CurrentLocation);
		
		try {
		
			// Tell the server's listening thread to close down
			this.serverthread.isFinished = true;
			// Kill the object to orphan socket objects
			this.serverthread = null;
			
		}
		catch (Exception e) {
			// Do nothing about the exception - these objects
			// can be already destroyed by the time we get here	
		}
		
		// Remove this player from the players collection.
		int i = 1;
		player p = null;
		while (i <= data.oplayers.getCount()) {
			p = (player) data.oplayers.get(i);
			if (p.Index == this.Index) {
				// Found the player - remove it
				data.oplayers.remove(i);
				break;
			}
			i++;
		}
		
		// Update the console
		vdu.updateconnectionlist();
	}
	
	/*** Marks a location as visited by this player */
	public void MarkLocationAsSeen(long locid) {
		LocationsSeen.add(new Long(locid));
	}
  
	/*** Returns true if this player has seen the passed in location */
	public boolean HasSeenLocation(long locid) {
		int i = 1;
		Long id;
		while (i <= LocationsSeen.getCount()) {
			id = (Long) LocationsSeen.get(i);
			if (id.longValue() == locid) {
				return true;	
			}
			i++;
		}
		return false;
	}
	
	/**
	*  Displays the player's score to them.
	*/
	public void showscore() {
		interpreter ti = new interpreter(this, null);
		ti.runcode(data.ogame.OnScore, "Player(" + Integer.toString(Index) + ").OnScore");
	}

	/**
	 *  Display battle status to player
	 */
	public void showstatus() {
		vdu.Transmit(processor.smake(message.getMessage(constant.MSG_STATUS), Long.toString(this.HitPoints), Long.toString(this.DamageIndicator), Long.toString(this.ChanceOfHitting)), this);
	}

	/** Handles saving of player state */
	public void SaveState(String password, String identifier) {
	
		// Note that because this is in an internal server function, we do not
		// need to allow the user to customise this, so we
		// can sigh with relief and hardcode some messages :)
		
		// Make sure persistence is allowed
		if (!data.ogame.AllowPersist) {
			vdu.Transmit("You cannot save your position in this game.", this);
			return;
		}
		
		// Check which type and tell the player
		if (data.ogame.SinglePlayerGame) {
			vdu.Transmit("Saving state for single player game...", this);	
		}
		else
		{
			vdu.Transmit("Saving state for multi-player game...", this);
		}
		
		// Build our file name of <game_name>_<nick>_<identifier>.state
		String filenamepath = data.gamepath + "." + this.Name + "_" + identifier + ".state";
		
		// Create a file handle to our new output file
		File fh = new File(filenamepath);
		
		// If the file exists, read the password from it to see if 
		// we are allowed to overwrite it.
		if (fh.exists()) {
			vdu.Transmit("File exists, checking security...", this);	
			// Open input stream on it:
			try {
				FileInputStream in = new FileInputStream(fh);
				
				// the third line should contain our password
				String rl = data.readline(in);
				rl = data.readline(in);
				rl = data.readline(in);
				
				// decrypt the password
				data.isencrypted = true;
				rl = data.decrypt(rl);
				
				// see if it matches what we were given:
				if (!password.equals(rl)) {
					vdu.Transmit("Security check failed - incorrect password. Save state failed.", this);
					return;					
				}
				else
				{
					vdu.Transmit("Security check passed...", this);	
				}
				
			}
			catch(IOException e) {
				vdu.println("Unable to check security in file: " + filenamepath);
				vdu.Transmit("Unable to read file, save state failed.", this);
				e.printStackTrace();	
			}				
		}
		
		try {
			
			FileOutputStream out = new FileOutputStream(fh);
			
			// Write the header:
			writelineunencrypted(out, "IAGE 2 SAVE");
			writelineunencrypted(out, "1"); // always encrypt saves
			// Password
			writeline(out, password);
			// Game type
			if (data.ogame.SinglePlayerGame) {
				writeline(out, "1");
			}
			else
			{
				writeline(out, "0");
			}
			
			// Player properties:
			writeline(out, "PLAYER");
			writeline(out, "Name = " + this.Name);
			writeline(out, "CanSee = " + data.booleanToString(this.CanSee));
			writeline(out, "ChanceOfHitting = " + Long.toString(this.ChanceOfHitting));
			writeline(out, "CurrentLocation = " + Long.toString(this.CurrentLocation));
			writeline(out, "DamageIndicator = " + Long.toString(this.DamageIndicator));
			writeline(out, "DisplayName = " + this.DisplayName);
			writeline(out, "HitPoints = " + Long.toString(this.HitPoints));
			writeline(out, "ItemsCarried = " + Long.toString(this.ItemsCarried));
			writeline(out, "Money = " + Long.toString(this.Money));
			writeline(out, "Score = " + Long.toString(this.Score));
			writeline(out, "SizeCarried = " + Long.toString(this.SizeCarried));
			writeline(out, "Turns = " + Long.toString(this.Turns));
			writeline(out, "WeightCarried = " + Long.toString(this.WeightCarried));
			writeline(out, "CP1 = " + this.CP1);
			writeline(out, "CP2 = " + this.CP2);
			writeline(out, "CP3 = " + this.CP3);
			writeline(out, "CP4 = " + this.CP4);
			writeline(out, "CP5 = " + this.CP5);
			writeline(out, "CP6 = " + this.CP6);
			writeline(out, "CP7 = " + this.CP7);
			writeline(out, "CP8 = " + this.CP8);
			writeline(out, "CP9 = " + this.CP9);
			writeline(out, "CP10 = " + this.CP10);
			writeline(out, "CP11 = " + this.CP11);
			writeline(out, "CP12 = " + this.CP12);
			writeline(out, "CP13 = " + this.CP13);
			writeline(out, "CP14 = " + this.CP14);
			writeline(out, "CP15 = " + this.CP15);
			writeline(out, "CP16 = " + this.CP16);
			writeline(out, "CP17 = " + this.CP17);
			writeline(out, "CP18 = " + this.CP18);
			writeline(out, "CP19 = " + this.CP19);
			writeline(out, "CP20 = " + this.CP20);
			writeline(out, "CP21 = " + this.CP21);
			writeline(out, "CP22 = " + this.CP22);
			writeline(out, "CP23 = " + this.CP23);
			writeline(out, "CP24 = " + this.CP24);
			writeline(out, "CP25 = " + this.CP25);
			writeline(out, "CP26 = " + this.CP26);
			writeline(out, "CP27 = " + this.CP27);
			writeline(out, "CP28 = " + this.CP28);
			writeline(out, "CP29 = " + this.CP29);
			writeline(out, "CP30 = " + this.CP30);
			
			// Output namevalue pairs for this player - note that we
			// break from traditional formats here and use a new one
			// NV <name> <value> - it needs to be on one line because
			// different things can occur in different orders.
			int i = 1;
			namevaluepair nv = null;
			while (i <= this.NameValues.getCount()) {
				nv = (namevaluepair) this.NameValues.get(i);
				writeline(out, "NV " + nv.Name + " " + nv.Value);
				i++;
			}			
			
			writeline(out, "END");
			
			// If this is not a single player game, we are finished!
			if (!data.ogame.SinglePlayerGame) {
				vdu.Transmit("Save successful.", this);
				return;
			}
			
			// Single player game - save locations, items, NPCs and flags too.
	  		location l = null;
	  		item im = null;
	  		character cc = null;	
			
			writeline(out, "");
	  		writeline(out, "LOCATIONS");
	  		writeline(out, "");
	  		i = 1;
	  		while (i <= data.olocations.getCount()) {
	  			l = (location) data.olocations.get(i);
	  			writeline(out, "ID = " + Long.toString(l.ID));
	  			writeline(out, "Name = " + l.Name);
	  			writeline(out, "ImagePath = " + l.ImagePath);
	  			writeline(out, "Description = " + l.Description);
	  			writeline(out, "IsDark = " + data.booleanToString(l.IsDark));
	  			writeline(out, "CustomProperties = " + l.CustomProperties);
	  			writeline(out, "N = " + Long.toString(l.N));
	  			writeline(out, "S = " + Long.toString(l.S));
	  			writeline(out, "E = " + Long.toString(l.E));
	  			writeline(out, "W = " + Long.toString(l.W));
	  			writeline(out, "U = " + Long.toString(l.U));
	  			writeline(out, "D = " + Long.toString(l.D));
	  			writeline(out, "NE = " + Long.toString(l.NE));
	  			writeline(out, "NW = " + Long.toString(l.NW));
	  			writeline(out, "SE = " + Long.toString(l.SE));
	  			writeline(out, "SW = " + Long.toString(l.SW));
				
				// Output namevalue pairs for this location - note that we
				// break from traditional formats here and use a new one
				// NV <name> <value> - it needs to be on one line because
				// different things can occur in different orders.
				int ic = 1;
				while (ic <= l.NameValues.getCount()) {
					nv = (namevaluepair) l.NameValues.get(ic);
					writeline(out, "NV " + nv.Name + " " + nv.Value);
					ic++;
				}
	  			if (i < data.olocations.getCount()) writeline(out, "BREAK");
	  			i++;	
	  		}
	  		writeline(out, "");
	  		writeline(out, "END");
	  		
	  		// Items
	  		writeline(out, "");
	  		writeline(out, "ITEMS");
	  		writeline(out, "");
	  		i = 1;
	  		while (i <= data.oitems.getCount()) {
	  			im = (item) data.oitems.get(i);
	  			writeline(out, "ID = " + Long.toString(im.ID));
	  			writeline(out, "Name = " + im.Name);
	  			writeline(out, "CurrentLocation = " + Long.toString(im.CurrentLocation));
	  			writeline(out, "Weight = " + Long.toString(im.Weight));
	  			writeline(out, "Description = " + im.Description);
	  			writeline(out, "CustomProperties = " + im.CustomProperties);
	  			writeline(out, "UserBooleans = " + im.UserBooleans);
	  			writeline(out, "NounID = " + Long.toString(im.NounID));
	  			writeline(out, "IsLightSource = " + data.booleanToString(im.IsLightSource));
	  			writeline(out, "IsLit = " + data.booleanToString(im.IsLit));
	  			writeline(out, "IsWorn = " + data.booleanToString(im.IsWorn));
	  			writeline(out, "IsWeapon = " + data.booleanToString(im.IsWeapon));
	  			writeline(out, "HasSurface = " + data.booleanToString(im.HasSurface));
	  			writeline(out, "CanBeLaidOn = " + data.booleanToString(im.CanBeLaidOn));
	  			writeline(out, "CanBeStoodOn = " + data.booleanToString(im.CanBeStoodOn));
	  			writeline(out, "CanBeSatOn = " + data.booleanToString(im.CanBeSatOn));
	  			writeline(out, "CanBeGotIn = " + data.booleanToString(im.CanBeGotIn));
	  			writeline(out, "DefaultExamine = " + im.DefaultExamine);
	  			writeline(out, "IsContainer = " + data.booleanToString(im.IsContainer));
	  			writeline(out, "IsEdible = " + data.booleanToString(im.IsEdible));
	  			writeline(out, "EdibleHitPoints = " + Long.toString(im.EdibleHitPoints));
	  			writeline(out, "IsWearable = " + data.booleanToString(im.IsWearable));
	  			writeline(out, "IsReadable = " + data.booleanToString(im.IsReadable));
	  			writeline(out, "ReadableText = " + im.ReadableText);
	  			writeline(out, "Size = " + Long.toString(im.Size));
	  			writeline(out, "DamageIndicator = " + Long.toString(im.DamageIndicator));
	  			writeline(out, "Invisible = " + data.booleanToString(im.Invisible));
	  			writeline(out, "IsFixed = " + data.booleanToString(im.IsFixed));
	  			writeline(out, "CanOpenClose = " + data.booleanToString(im.CanOpenClose));
	  			writeline(out, "OpenCloseState = " + data.booleanToString(im.OpenCloseState));
	  			writeline(out, "FixedMessage = " + im.FixedMessage);
	  			writeline(out, "IsSubItem = " + data.booleanToString(im.IsSubItem));
	  			writeline(out, "SubItemOf = " + Long.toString(im.SubItemOf));
	  			
	  			// Output namevalue pairs for this item - note that we
	  			// break from traditional formats here and use a new one
	  			// NV <name> <value> - it needs to be on one line because
	  			// different things can occur in different orders.
				int ic = 1;
				nv = null;
				while (ic <= im.NameValues.getCount()) {
					nv = (namevaluepair) im.NameValues.get(ic);
					writeline(out, "NV " + nv.Name + " " + nv.Value);
					ic++;
				}			
				
				if (i < data.oitems.getCount()) writeline(out, "BREAK");
	  			i++;	
	  		}
	  		writeline(out, "");
	  		writeline(out, "END");

	  		// Characters
	  		
	  		writeline(out, "");
	  		writeline(out, "CHARACTERS");
	  		writeline(out, "");
	  		i = 1;
	  		while (i <= data.ocharacters.getCount()) {
	  			cc = (character) data.ocharacters.get(i);
	  			writeline(out, "ID = " + Long.toString(cc.ID));
	  			writeline(out, "Name = " + cc.Name);
	  			writeline(out, "CurrentLocation = " + Long.toString(cc.CurrentLocation));
	  			writeline(out, "Description = " + cc.Description);
	  			writeline(out, "NounID = " + Long.toString(cc.NounID));
	  			writeline(out, "TimerInterval = " + Long.toString(cc.TimerInterval));
	  			writeline(out, "DefaultExamine = " + cc.DefaultExamine);
	  			writeline(out, "HitPoints = " + Long.toString(cc.HitPoints));
	  			writeline(out, "DamageIndicator = " + Long.toString(cc.DamageIndicator));
	  			writeline(out, "AutoAttack = " + data.booleanToString(cc.AutoAttack));
	  			writeline(out, "AttackWhenAttacked = " + data.booleanToString(cc.AttackWhenAttacked));
	  			writeline(out, "Money = " + Long.toString(cc.Money));
	  			
				// Output namevalue pairs for this location - note that we
				// break from traditional formats here and use a new one
				// NV <name> <value> - it needs to be on one line because
				// different things can occur in different orders.
				int ic = 1;
				while (ic <= cc.NameValues.getCount()) {
					nv = (namevaluepair) cc.NameValues.get(ic);
					writeline(out, "NV " + nv.Name + " " + nv.Value);
					ic++;
				}
	  			
				if (i < data.ocharacters.getCount()) writeline(out, "BREAK");
	  			i++;	
	  		}
	  		writeline(out, "");
	  		writeline(out, "END");
	  		
	  		// Flags
	  		writeline(out, "");
	  		writeline(out, "FLAGS");
	  		writeline(out, "");
	  		i = 1;
	  		while (i <= data.maxflags - 1) {
	  			writeline(out, "Index = " + Integer.toString(i));
	  			writeline(out, "Value = " + data.oflags[i].Value);
	  			if (i < data.maxflags) writeline(out, "BREAK");
	  			i++;
	  		}
	  		writeline(out, "");
	  		writeline(out, "END");
			
			vdu.Transmit("Save successful.", this);
			data.ogame.displaylocation(this);
			
		}
		catch(IOException e) {
			vdu.println("Unable to write to file: " + filenamepath);
			vdu.Transmit("Unable to write to file, save state failed.", this);
			e.printStackTrace();
		}
		
	}
	
	/** Handles restoring of player state */
	public boolean RestoreState(String password, String identifier) {
		
		// Note that because this is in an internal server function, we do not
		// need to allow the user to customise this, so we
		// can sigh with relief and hardcode some messages :)
		
		// Make sure persistence is allowed
		if (!data.ogame.AllowPersist) {
			vdu.Transmit("You cannot restore your position in this game.", this);
			return false;
		}
		
		// Build our file name of <game_name>_<nick>_<identifier>.state
		String filenamepath = data.gamepath + "." + this.Name + "_" + identifier + ".state";
		
		// Create a file handle to our new input file
		File fh = new File(filenamepath);
		
		// Make sure the file exists
		if (!fh.exists()) {
			vdu.Transmit("File does not exist - restore state failed.", this);
			return false;
		}
		else
		{
			vdu.Transmit("Found state file, checking security...", this);	
		}
		
		// Open an input stream on the file and do the restore
		try {
			FileInputStream in = new FileInputStream(fh);
			String buff;
			
			data.fileeof = false;
			buff = data.readline(in);
			
			// Check header
			if (!buff.equalsIgnoreCase("IAGE 2 SAVE")) {
				vdu.Transmit("Bad file format - restore state failed.", this);
				return false;
			}
			
			// Skip encrypted flag - saves are always encrypted
			buff = data.readline(in);
			
			// Read the password
			data.isencrypted = true;
			buff = data.decrypt(data.readline(in));
			
			// Compare it to the one we were given
			if (!buff.equals(password)) {
				vdu.Transmit("Incorrect password - restore state failed.", this);
				return false;
			}
			else
			{
				vdu.Transmit("Security check passed, restoring position...", this);
			}
			
			// Start our main drag through the file:
			while (!data.fileeof) {
				
				buff = data.decrypt(data.readline(in));
				
				if (buff.trim().equalsIgnoreCase("PLAYER")) {
					restoreplayer(in);
				}
				
				if (buff.trim().equalsIgnoreCase("LOCATIONS")) {
					restorelocations(in);
				}
				
				if (buff.trim().equalsIgnoreCase("ITEMS")) {
					restoreitems(in);
				}
				
				if (buff.trim().equalsIgnoreCase("FLAGS")) {
					restoreflags(in);
				}
				
				if (buff.trim().equalsIgnoreCase("CHARACTERS")) {
					restorecharacters(in);
				}
			}
			
			vdu.Transmit("Restore successful.", this);
			data.ogame.displaylocation(this);
			return true;
			
		}
		catch(IOException e) {
			vdu.Transmit("Unable to read from file - restore state failed.", this);
			e.printStackTrace();
			return false;
		}
	}
	
	private void restoreplayer(FileInputStream in) {
		
		// Restores player properties
		
		String buff;
		buff = data.decrypt(data.readline(in));
		
		while (buff.indexOf("END") == -1 && !data.fileeof) {
			
			if (data.comparebuff(buff, "Name") == true) {this.Name = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CanSee") == true) {this.CanSee = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "ChanceOfHitting") == true) {this.ChanceOfHitting = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "CurrentLocation") == true) {this.CurrentLocation = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "DamageIndicator") == true) {this.DamageIndicator = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "DisplayName") == true) {this.DisplayName = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "HitPoints") == true) {this.HitPoints = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "ItemsCarried") == true) {this.ItemsCarried = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "Money") == true) {this.Money = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "Score") == true) {this.Score = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "SizeCarried") == true) {this.SizeCarried = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "Turns") == true) {this.Turns = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "WeightCarried") == true) {this.WeightCarried = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "CP1") == true) {this.CP1 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP2") == true) {this.CP2 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP3") == true) {this.CP3 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP4") == true) {this.CP4 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP5") == true) {this.CP5 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP6") == true) {this.CP6 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP7") == true) {this.CP7 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP8") == true) {this.CP8 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP9") == true) {this.CP9 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP10") == true) {this.CP10 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP11") == true) {this.CP11 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP12") == true) {this.CP12 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP13") == true) {this.CP13 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP14") == true) {this.CP14 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP15") == true) {this.CP15 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP16") == true) {this.CP16 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP17") == true) {this.CP17 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP18") == true) {this.CP18 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP19") == true) {this.CP19 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP20") == true) {this.CP20 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP21") == true) {this.CP21 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP22") == true) {this.CP22 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP23") == true) {this.CP23 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP24") == true) {this.CP24 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP25") == true) {this.CP25 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP26") == true) {this.CP26 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP27") == true) {this.CP27 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP28") == true) {this.CP28 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP29") == true) {this.CP29 = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CP30") == true) {this.CP30 = data.getpropvalue_string(buff);}
			if (buff.trim().startsWith("NV")) { // Name value pair - 
												parsestring ps = new parsestring(buff, this, " ");
												String valname = (String) ps.vwords.get(2);
												String newval = (String) ps.vwords.get(3);
												this.setNameValue(valname, newval);
											  }
			
			buff = data.decrypt(data.readline(in));
			
		}
	}
		
	private void restorelocations(FileInputStream in) {
		
		// Restores locations
		
		location l = null;
		int i;
		long findid;
		String buff;
		buff = data.decrypt(data.readline(in));
		while (buff.indexOf("END") == -1 && !data.fileeof) {
			
			// If we have an ID field, find that matching location
			// in the collection to update it:
			if (data.comparebuff(buff, "ID") == true) {
				// Find the location with this ID
				i = 1;
				findid = data.getpropvalue_long(buff);
				while (i <= data.olocations.getCount()) {
					l = (location) data.olocations.get(i);	
					if (l.ID == findid) break;
					i++;
				}
			}
		
			if (data.comparebuff(buff, "Name") == true) {l.Name = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "ImagePath") == true) {l.ImagePath = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "Description") == true) {l.Description = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "IsDark") == true) {l.IsDark = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "N") == true) {l.N = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "S") == true) {l.S = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "E") == true) {l.E = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "W") == true) {l.W = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "U") == true) {l.U = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "D") == true) {l.D = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "NE") == true) {l.NE = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "NW") == true) {l.NW = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "SE") == true) {l.SE = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "SW") == true) {l.SW = data.getpropvalue_long(buff);}
			if (buff.trim().startsWith("NV")) { // Name value pair - 
												parsestring ps = new parsestring(buff, new player(), " ");
												String valname = (String) ps.vwords.get(2);
												String newval = (String) ps.vwords.get(3);
												l.setNameValue(valname, newval);
											  }
			
			buff = data.decrypt(data.readline(in));
		}
	}
	
	private void restoreitems(FileInputStream in) {
		
		// Restores Items
		
		item im = null;
		int i;
		long findid;
		String buff;
		buff = data.decrypt(data.readline(in));
		while (buff.indexOf("END") == -1 && !data.fileeof) {
			
			// If we have an ID field, find that matching item
			// in the collection to update it:
			if (data.comparebuff(buff, "ID") == true) {
				// Find the item with this ID
				i = 1;
				findid = data.getpropvalue_long(buff);
				while (i <= data.oitems.getCount()) {
					im = (item) data.oitems.get(i);	
					if (im.ID == findid) break;
					i++;
				}
			}
		
			if (data.comparebuff(buff, "Name") == true) {im.Name = data.getpropvalue_string(buff);}
			// Currentlocation is a bit special - since we can only ever have one
			// person in a single player game, any PLAYERBASE ranges should be matched to
			// the current player.
			if (data.comparebuff(buff, "CurrentLocation") == true) {im.CurrentLocation = data.getpropvalue_long(buff);}
			if (im != null) {
			if (im.CurrentLocation > location.PLAYERBASE && im.CurrentLocation < location.CONTAINERBASE) 
				{im.CurrentLocation = (location.PLAYERBASE + this.Index);} 
			}
			if (data.comparebuff(buff, "Weight") == true) {im.Weight = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "Description") == true) {im.Description = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "UserBooleans") == true) {im.UserBooleans = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "NounID") == true) {im.NounID = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "IsLightSource") == true) {im.IsLightSource = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "IsLit") == true) {im.IsLit = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "IsWorn") == true) {im.IsWorn = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "IsWeapon") == true) {im.IsWeapon = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "HasSurface") == true) {im.HasSurface = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "CanBeLaidOn") == true) {im.CanBeLaidOn = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "CanBeStoodOn") == true) {im.CanBeStoodOn = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "CanBeGotIn") == true) {im.CanBeGotIn = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "CanBeSatOn") == true) {im.CanBeSatOn = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "DefaultExamine") == true) {im.DefaultExamine = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "IsContainer") == true) {im.IsContainer = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "IsEdible") == true) {im.IsEdible = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "EdibleHitPoints") == true) {im.EdibleHitPoints = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "IsWearable") == true) {im.IsWearable = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "IsReadable") == true) {im.IsReadable = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "ReadableText") == true) {im.ReadableText = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "Size") == true) {im.Size = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "DamageIndicator") == true) {im.DamageIndicator = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "Invisible") == true) {im.Invisible = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "IsFixed") == true) {im.IsFixed = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "CanOpenClose") == true) {im.CanOpenClose = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "FixedMessage") == true) {im.FixedMessage = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "IsSubItem") == true) {im.IsSubItem = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "SubItemOf") == true) {im.SubItemOf = data.getpropvalue_long(buff);}
			if (buff.trim().startsWith("NV")) { // Name value pair - 
												parsestring ps = new parsestring(buff, new player(), " ");
												String valname = (String) ps.vwords.get(2);
												String newval = (String) ps.vwords.get(3);
												im.setNameValue(valname, newval);
											  }
			
			buff = data.decrypt(data.readline(in));
		}
	}
	
	private void restorecharacters(FileInputStream in) {
	
		// Restores Characters
		
		character cc = null;
		int i;
		long findid;
		String buff;
		buff = data.decrypt(data.readline(in));
		while (buff.indexOf("END") == -1 && !data.fileeof) {
			
			// If we have an ID field, find that matching item
			// in the collection to update it:
			if (data.comparebuff(buff, "ID") == true) {
				// Find the item with this ID
				i = 1;
				findid = data.getpropvalue_long(buff);
				while (i <= data.ocharacters.getCount()) {
					cc = (character) data.ocharacters.get(i);	
					if (cc.ID == findid) break;
					i++;
				}
			}
			
			if (data.comparebuff(buff, "Name") == true) {cc.Name = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "CurrentLocation") == true) {cc.CurrentLocation = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "Description") == true) {cc.Description = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "NounID") == true) {cc.NounID = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "TimerInterval") == true) {cc.TimerInterval = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "DefaultExamine") == true) {cc.DefaultExamine = data.getpropvalue_string(buff);}
			if (data.comparebuff(buff, "HitPoints") == true) {cc.HitPoints = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "DamageIndicator") == true) {cc.DamageIndicator = data.getpropvalue_long(buff);}
			if (data.comparebuff(buff, "AutoAttack") == true) {cc.AutoAttack = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "AttackWhenAttacked") == true) {cc.AttackWhenAttacked = data.getpropvalue_boolean(buff);}
			if (data.comparebuff(buff, "Money") == true) {cc.Money = data.getpropvalue_long(buff);}
			if (buff.trim().startsWith("NV")) { // Name value pair - 
												parsestring ps = new parsestring(buff, new player(), " ");
												String valname = (String) ps.vwords.get(2);
												String newval = (String) ps.vwords.get(3);
												cc.setNameValue(valname, newval);
											  }
			
			buff = data.decrypt(data.readline(in));
			
		}
	}
	
	private void restoreflags(FileInputStream in) {
	
		int flagindex = 1;
		String buff;
		buff = data.decrypt(data.readline(in));
		
		while (buff.indexOf("END") == -1 && !data.fileeof) {
			
			// If we have an index, change to that
			if (data.comparebuff(buff, "index") == true) {
				flagindex = (int) data.getpropvalue_long(buff);
			}
			if (data.comparebuff(buff, "Value") == true) {data.oflags[flagindex].Value = data.getpropvalue_string(buff);}		
			
			buff = data.decrypt(data.readline(in));
		}
	}
	
  /*** Writes a line of text to the outputstream specified */
  private void writeline(FileOutputStream out, String s) {
  	
  	s = data.encrypt(s);
  	byte[] ba = s.getBytes();
  	try {
  		out.write(ba);
  		// Dump a Windows type carriage return - it's a bytestream, who cares!
  		// The read process looks for Windows type carriage returns anyway
  		byte[] bb = { 13, 10 };
  		out.write(bb);
  	}
  	catch (Exception e) {
  		e.printStackTrace();
  		vdu.println("Error writing to file - " + e.getMessage());
  	}
  	
  }
  
  /*** Writes a line of unencrypted text to the outputstream specified */
  private void writelineunencrypted(FileOutputStream out, String s) {
  	
  	byte[] ba = s.getBytes();
  	try {
  		out.write(ba);
  		// Dump a Windows type carriage return - it's a bytestream, who cares!
  		// The read process looks for Windows type carriage returns anyway
  		byte[] bb = { 13, 10 };
  		out.write(bb);
  	}
  	catch (Exception e) {
  		e.printStackTrace();
  		vdu.println("Error writing to file - " + e.getMessage());
  	}
  	
  }
  
  	public String getNameValue(String valname) {
	
		 // Find value of this name
		 int ic = 1;
		 namevaluepair nv = null;
		 while (ic <= this.NameValues.getCount()) {
		 	 nv = (namevaluepair) this.NameValues.get(ic);
		 	 if (nv.Name.equalsIgnoreCase(valname)) {
		 	 	// Found it - return the value
		 	 	return nv.Value;
		 	 }
		     ic++;	 	
		 }	
		 return "0";
	}
	
	public void setNameValue(String valname, String newval) {
	
		// Hunt through to see if we already have a value with
		// this name:
		 int ic = 1;
		 namevaluepair nv = null;
		 
		 while (ic <= this.NameValues.getCount()) {
		 	 nv = (namevaluepair) this.NameValues.get(ic);
		 	 if (nv.Name.equalsIgnoreCase(valname)) {
		 	 	
		 	 	// We have one, replace the value
		 	 	nv.Value = newval;
		 	 	return;
		 	 }
		     ic++;	 	
		 }
		 
	 	// Add it
	 	nv = new namevaluepair();
	 	nv.Name = valname;
	 	nv.Value = newval;
	 	this.NameValues.add(nv);
		
	}
	
	/*** Marks this player as having been asked a question by the
	     parser, so it can respond on their next input appropriately */
	public void askParserQuestion(parsestring p, int nounToReplace) {
		this.LastParser = p;
		this.LastQReplacesNoun = nounToReplace;
		this.LastParserAskedQuestion = true;		
	}
  
}
