package iageserver;

import java.io.*;
import java.net.*;

/**
 * Serverlistenthread class. Each new client connection causes an instantiation of one
 * of these to service it's requests.
 */
public class serverlistenthread extends Thread {
        
  /** Determines if we are listening for client input on the socket. */
  public boolean isFinished = false;
  /** Reference to the player object this socket is connected to. */
  private player pr = null;           

  /** Creates a new listenthread on the passed client socket. Also creates a
    * new player object for the connection and sets appropriate references to this
    * object and the player
    */
  public serverlistenthread(Socket socket) {
  	
      super("serverlistenthread");
      
      // Work out if we are in single player mode, if so, we may as well
      // set the max users to 1.
      if (data.ogame.SinglePlayerGame) {
	  	  data.ogame.MaxUsers = 1;
	  }
      
      // Check to make sure we aren't going over our maximum number of
	  // players. If we are, send a message explaining that the server 
	  // cannot accept any more connections.
	  if(data.oplayers.getCount() == data.ogame.MaxUsers) {
	  	
	  	  // Create a socket stream to output an error message
	  	  try {
	  	  	  PrintWriter outstream = new PrintWriter(socket.getOutputStream(), true);
			  outstream.write("Server has exceeded capacity (" + Integer.toString(data.ogame.MaxUsers) + " simultaneous users)");
			  outstream.flush();
		  }
		  catch (IOException e) {
		  	  vdu.println("Unable to create socket stream for server full message: " + e.getMessage());
	          e.printStackTrace();		  
		  }
		  
		  // Mark this instance of the listenthread as finished
		  // to orphan this socket and destroy this thread
		  isFinished = true;
		  
		  return;
	  }
      
      // Create a player for this socket
      pr = new player();
      
      pr.PlayerSocketHandle = socket;
      data.numberofconnections++;
      vdu.println("Received connection from " + pr.PlayerSocketHandle.getInetAddress().getHostAddress() + " (process " + Integer.toString(data.numberofconnections) + " on port " + Integer.toString(pr.PlayerSocketHandle.getLocalPort()) + ")");
      
      // Create streams on player object
      try {
	      pr.socket_outputstream = new PrintWriter(pr.PlayerSocketHandle.getOutputStream(), true);
	      pr.socket_inputstream = new DataInputStream(pr.PlayerSocketHandle.getInputStream());
	  }      
	  catch(IOException e) {
	  	vdu.println("Error creating socket streams: " + e.getMessage());
	  	e.printStackTrace();
	  	return;
	  }	
      // Set player properties
      pr.IPAddress = pr.PlayerSocketHandle.getInetAddress().toString();
      pr.Score = 0;
      pr.Turns = 0;
      pr.VerboseMode = data.ogame.RepeatDescription;
      pr.SizeCarried = 0;
      pr.WeightCarried = 0;
      pr.ItemsCarried = 0;
      
      // Generate a random location if we have a -1 by
      // default, otherwise use the starting one in the game.
      if (data.ogame.StartingLocation == -1) {
      	pr.CurrentLocation = data.ogame.getRandomLocation();
      }
      else
      {
      	pr.CurrentLocation = data.ogame.StartingLocation;
      }
      pr.Index = data.nextplayerID;
      data.nextplayerID++;
      pr.Name = data.defaultnewplayername;
      
      // Money and combat
      pr.HitPoints = data.ogame.DefaultHitPoints;
      pr.Money = data.ogame.DefaultMoney;
      pr.DamageIndicator = data.ogame.DefaultDamage;
      pr.ChanceOfHitting = data.ogame.DefaultChanceOfHitting;
      
      // Set a reference to our running thread
      pr.serverthread = this;
      
      // Add player into collection
      data.oplayers.add(pr);
      
      // Show the connection at the console
      vdu.updateconnectionlist();
  }

  /** Main routine. Listens for client input and fires off processor objects */
  public void run() {

    byte[] ba = new byte[1024];
    String inbuffer;
    int i;

    try {

      while ( !isFinished ) {

		i = pr.socket_inputstream.read(ba);
		
		if (i > 0) {
		
			inbuffer = new String(ba);
			inbuffer = inbuffer.substring(0, i);
			
			if (inbuffer.length() > 0) {
				// Pass to separately threaded processor object
				new processor(inbuffer, pr);
			}
	    }
	    try {
        	this.sleep(20);
        } 
        catch (InterruptedException e) {}
        
      }

    } catch (IOException e) {
        e.printStackTrace();
    }
    finally {
    	
    	try {
	    	pr.socket_inputstream.close();
	        pr.socket_outputstream.close();
        	pr.PlayerSocketHandle.close();
        }
        catch (Exception e) {}
    	
    	data.numberofconnections--;
    	// Make sure the player object is really
    	// destroyed.
    	pr.quit(true);
    }
  }
}