
! ---------------------------------------------------------------------
! StrNames.h (for Inform 6)
! Version 0.2/070603
! by Chipjack <chipjack@gmail.com>
! ---------------------------------------------------------------------
! Please report bugs on rec.arts.int-fiction, rather than by email.
! StrNames has been released into the Public Domain; you may use it
! in any way you wish.
!
! Use strings in a property array as names for an object; provides
! for names longer than nine characters and multiword names; with
! support for plural-tagging. Have a look at StrNames.inf for an
! example of how to do nearly anything you might want to do with
! this library extension.
! ---------------------------------------------------------------------
! Release History
! ---------------------------------------------------------------------
! 2007-06-03 v0.2 (Chipjack):
!    Updated to handle plurals, and to better integrate into derived
!    classes that provide their own parse_name routines.
! 2007-06-01 v0.1 (Chipjack):
!    Initial Version.
! ---------------------------------------------------------------------
!
! Basic Usage:
!  Make your item an LObject, rather than just an Object, give it a
!  long_names property that works like the name property, but with
!  strings instead of dictionary words. (That is, "strings", instead
!  of 'words'.)
!
! Advanced Usage:
!  If you want to mark an entry in your long_names property as being
!  plural, put a _PLURAL_ in front of it. That, in essence, adds a new
!  entry into the array, with a value of zero, and you could just as
!  easily use a zero, but using the _PLURAL_ constant results in more
!  self-documenting code. Be sure to follow _PLURAL_ with a space to
!  separate it from your string.
!
!  If you want one of your own classes to inherit from LObject, just
!  use the "class" keyword to say so:
!
!    Class myClass
!      class LObject
!      with ...
!
!  If your derived class uses its own parse_name routine, you may want
!  to explicitly call "self.LObject::parse_name()" somewhere in it to
!  continue to make use of the long_names functionality LObject
!  provides.
!
!  The routine that actually checks the long_names property against the
!  player input is "_match_long_names", so you might just make a call
!  like "wc = self._match_long_names();" to get the number of matching
!  words from whatever string in long_names matches the best, then
!  carry on with whatever your parse_name routine needs to do.
!
!  Again, you might want to check out the example game, StrNames.inf,
!  for examples of using these calls in derived classes.
!
! ---------------------------------------------------------------------



Global lwn;
Array lbuffer -> 123;
Array lparse buffer 63;
Array cbuffer -> 123;

Constant _PLURAL_ 0;

Class LObject with
parse_name [w i wc mc own ln;
	if (parser_action == ##TheSame) {
		if(~~(self provides long_names)) {
			if(parser_one.#long_names ~= parser_two.#long_names)
				return -2;
			for (i = 0: i < parser_one.#long_names: i++) {
				ln = parser_one.&long_names-->i.print_to_array(lbuffer);
				ln = parser_two.&long_names-->i.print_to_array(cbuffer);
				if(lbuffer-->0 ~= cbuffer-->0)
					return -2;
				if(~~WordEq(lbuffer, cbuffer, lbuffer-->0))
					return -2;
			}
			return 0; ! matches so far, let the parser figure it out
		}
		return 0; ! let the parser decide in the normal way
	}
	if(~~(self provides long_names))
		return -1;
	own = wn;
	while( (w=NextWordStopped()) ~= -1) {
		mc = self._match_long_names();
		if(mc) {
			wc = wc + mc;
			wn = wn + mc - 1;
		}
		else
			if(w && WordInProperty(w, self, name))
				wc++;
			else
				break;
	}
	wn = own;
	return wc;
],
_match_long_names [i pf m mc ln;
	if(~~(self provides long_names))
		return 0;
	ln = self.#long_names / 2;
	for (i = 0: i < ln: i++) {
		if(self.&long_names-->i == _PLURAL_) {
			pf = true; i++;
		}
		else
			pf = false;
		if( (m = WordsInString(wn - 1, self.&long_names-->i)) >mc) {
			mc = m;
			if(pf) parser_action = ##PluralFound;
		}
	}
	return mc;
];

[WordsInString n s ln own wc w lw;
	if(metaclass(s) ~= String) {
		! WordsInString only works with Strings, hence the name
		rfalse;
	}
	ln = s.print_to_array(lbuffer);
	lbuffer->0 = 120;
	lbuffer->1 = ln;
	lparse->0 = 15;
	@tokenise lbuffer lparse;
	own = wn; wn = n; lwn = 1;
	for(::) {
		w = NextWordStopped();
		lw = LNextWordStopped();
		if(lw == -1 && w == -1) {
			! no more words in string, no more in player input
			break;
		}
		if (w > -1 && lw == -1) {
			! no more words in string, player input continues
			break;
		}
		if(w == -1 && lw > -1) {
			! no more words in input, but the string is not finished yet
			wc = 0; ! must match the _entire_ string
			break;
		}
		if (w ~= lw) {
			! dictionary lookup should produce the same results for
			! words that match -- even if the results are 0 (not in
			! dictionary)
			wc = 0;
			break;
		}
		if (WordLength(wn - 1) ~= LWordLength(lwn - 1) ) {
			! words that are truly the same would be the same length
			wc = 0;
			break;
		}
		if( WordEq(WordAddress(wn - 1), LWordAddress(lwn - 1),
			WordLength(wn - 1)) ) {
			! here, we resort to actually comparing them, character
			! by character, and if they match, increment the match
			! counter
			wc++;
		}
	}
	wn = own;
	return wc;
];

[WordEq a b ln i;
	for(i=0:i<ln:i++)
		if(a->i ~= b->i)
			rfalse;
	rtrue;
];

! borrowed from the Inform Library, and modified a bit for our own use
[LNextWord i j;
	if (lwn > lparse->1) { lwn++; rfalse; }
	i = lwn*2-1; lwn++;
	j = lparse-->i;
	if (j == ',//') j = comma_word;
	if (j == './/') j = THEN1__WD;
	return j;
];

[LNextWordStopped;
	if (lwn > lparse->1) { lwn++; return -1; }
	return LNextWord();
];

[LWordAddress wordnum; return lbuffer + lparse->(wordnum*4+1); ];

[LWordLength wordnum; return lparse->(wordnum*4); ];


