!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2003.01.31 ORNPC_asktelllearn	[Z, GLULX]
! A module which endows an NPC with the ability to answer questions and learn 
! new information that has been told to it.  This module leverages the ORKnowledgeTopic
! module.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! AutoDep :	ORKnowledgeTopic
!--------------------------------------------------------------------------------------
! NPComPri: 10 (NPC Componant Priority) 
! The lower the number, the further down the "class" line.  The greater the number, 
! the earlier it needs to come on the class line. Modules with the same priority can
! effectively be exchanged in order without effect.
!--------------------------------------------------------------------------------------
! When derived from this componant, NPCs can answer asked questions, respond to topics 
! being told, and learn new topics. In short, this enables NPCs to respond to 
! ORKnowledgeTopic-related commands.
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#include "ORNPC_asktelllearn";					!Constant USE_ORNPC_asktelllearn; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORNPC_asktelllearn; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.02.05	Initial Creation (not really, but this is the earliest date I could 
!				find without searching my code archive)
! 2002.02.26	fit to new template
! 2002.03.23	added property to quash generic responses
! 2002.04.14	Fixed issue caused by .h removal.
! 2002.08.21	Added Auto dependancies for OROptionList and ORLibraryMessages 
!				(which were just recently added to ORKnowledgeTopic)
! 2002.09.02	Converted attributes previously defined in this module to properties.
! 2003.01.18	Fixed an ancient bug in the life routine which handled AnswerTopic.
!				Specifically, the code to swap noun and second assigned a zero.
! 2003.01.31	Reworking the whole linefeed concept in light of a posting to RAIF
!				from Andrew Plotkin.
!--------------------------------------------------------------------------------------
#ifdef USE_ORNPC_asktelllearn;message "          Processing library extension ORNPC_asktelllearn...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifndef USE_OROptionList; Constant USE_OROptionList; message "          ****Forcing inclusion of OROptionList****"; #include "OROptionList"; #endif;    	
	#ifndef USE_ORLibraryMessages; Constant USE_ORLibraryMessages; message "          ****Forcing inclusion of ORLibraryMessages****"; #include "ORLibraryMessages"; #endif; 
	#ifndef USE_ORDynaString; Constant USE_ORDynaString; message "          ****Forcing inclusion of ORDynaString****"; #include "ORDynaString"; #endif; 
	#ifndef USE_ORKnowledgeTopic; Constant USE_ORKnowledgeTopic; message "          ****Forcing inclusion of ORKnowledgeTopic****"; #include "ORKnowledgeTopic"; #endif; 
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORNPC_asktelllearn_DONEREPLACE; constant ORNPC_asktelllearn_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------
	global ignore_dialog=false;
!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORNPC_asktelllearn_DONEMESSAGE; constant ORNPC_asktelllearn_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORNPC_asktelllearn requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------
	[WillPlayerHear one two; 
		if(one==0)one=actor;
		if(two==0)two=actor;
		if(CanPlayerWitness(one)==false && CanPlayerWitness(two)==false) rfalse;
		if(player==one or two) rtrue;
		if(ignore_dialog==false && one has animate or talkable && two has animate or talkable) rtrue;
		rfalse; 
	];
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORNPC_asktelllearn_DONECODE;constant ORNPC_asktelllearn_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
	class ORNPC_asktelllearn
		with	acknowledge_conversation true
			,	AlreadyKnewResponse_msg [;
						if(ValueOrRun(self,acknowledge_conversation)==true) print "^~I knew that already,~ ",(ig)IVerb(self,"said","say"),".^";						
					]
			,	LearnedResponse_msg [;
						if(ValueOrRun(self,acknowledge_conversation)==true) print "^~Really?~ ",(ig)CIVerb(self,"said","say"), ".  ~I'll have to remember that.~^";
					]
			,	UnlearnedResponse_msg [;
						if(ValueOrRun(self,acknowledge_conversation)==true) print "^",(ig)CIVerb(self,"nodded","nod")," ",(My)self," head in acknowledgment.^";	
					]
			,	IDunno_msg [; 
						print "^~I'm afraid I don't know anything about that,~ ",(TheI)self," ",(ig)ppf("said","says"),".^";
					]	
			,	already_knows false
			,	generic_tell_topic !--respond if talked to. Implemented once here rather that twice in "life" 
				[;
					if(WillPlayerHear(self)==true){
						if((second provides rhetorical)==false||valueorrun(second,rhetorical)==false) {
							if(self provides already_knows  && self.already_knows==true) printorrun(self,AlreadyKnewResponse_msg);
							else {
								if(second.IsKnownBy(self)==true) printorrun(self,learnedResponse_msg);
								else printorrun(self,UnlearnedResponse_msg);
							}
						}
					}
					rtrue;
				]
			,	life [o;	
					ASKTopic:
						if((second==0) || ((second ofclass ORKnowledgeTopic)==false) || (second.isknownby(self)==false)){
							if(WillPlayerHear(self)==true) printorrun(self,IDunno_msg);
						}
						else {
							if(self==player)  !--if it is the player that was asked a question, then let us *not* automatically answer it as we would for an NPC
								self.PushOption(second); !--instead, we'll add it to the list of good things to say
							else{
								!---at this point, we can go ahead and answer the question
								o=actor;
								actor=self;
								<TellTopic o second>;
								actor=o;
	#ifdef USE_ORNPC_interact;
								if(self provides interacted) self.interacted();
	#endif;
							}
						}
						rtrue;
					Answer, Ask, Tell: if(actor==player) playeristalkingto=self;
					TellTopic: 
						return self.generic_tell_topic();
					AnswerTopic:	o=noun; noun=second; second=o;
					return self.generic_tell_topic();
			]
		,	rhetorical false 	!for knowlege topics, used to suppress response by NPCs when topic is learned
	;
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORNPC_asktelllearn_DONEGRAMMAR; constant ORNPC_asktelllearn_DONEGRAMMAR; #ifdef ORNPC_asktelllearn_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;