VERSION 5.00
Begin VB.Form frmVis 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Visual SINTAC"
   ClientHeight    =   3945
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   6150
   Icon            =   "Vis.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   263
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   410
   StartUpPosition =   2  'CenterScreen
   Begin VB.Timer Reloj 
      Enabled         =   0   'False
      Index           =   0
      Interval        =   1000
      Left            =   5640
      Top             =   0
   End
   Begin VB.CommandButton cmdPausa 
      Caption         =   "..."
      Default         =   -1  'True
      Height          =   255
      Left            =   5760
      TabIndex        =   2
      Top             =   3600
      Visible         =   0   'False
      Width           =   375
   End
   Begin VB.TextBox txtInput 
      Appearance      =   0  'Flat
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   0  'None
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000000&
      Height          =   285
      Left            =   0
      TabIndex        =   1
      Top             =   3600
      Visible         =   0   'False
      Width           =   5655
   End
   Begin VB.PictureBox Pantalla 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H00FFFFFF&
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000000&
      Height          =   3495
      Index           =   0
      Left            =   0
      ScaleHeight     =   231
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   375
      TabIndex        =   0
      Top             =   0
      Width           =   5655
   End
End
Attribute VB_Name = "frmVis"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' caracteres de secuencia de ESCAPE en cadenas de texto: \[cod. escape]
Const ESCAPE1 = "\"
Const ESCAPE2 = "["
Const ESCAPE3 = "]"
Const ESCAPE_SALTO = "R"        ' salto de lnea
Const ESCAPE_NEGRITA = "N"      ' inicio/fin de negrita: \[N]
Const ESCAPE_CURSIVA = "C"      ' inicio/fin de cursiva: \[C]
Const ESCAPE_SUBRAYADO = "S"    ' inicio/fin de subrayado: \[S]
Const ESCAPE_COLOR = "RGB("     ' cambio de color: \[RGB(rrggbb)]
Const ESCAPE_COLORF = "RGBF("   ' cambio de color de fondo: \[RGBF(rrggbb)]

Const MARGEN_DER = 8            ' margen derecho (en pixels)
Const MARGEN_INF = 16           ' margen inferior (en pixels)
Const MAX_INPUT = 10            ' mximo n de lneas input que se guardarn

Private bHayReloj As Boolean    ' si hay algn "temporizador" definido
Private lDondeInput As Long     ' indica en qu "pantalla" est haciendo "input" (-1 ninguna)
Private bFinInput As Boolean    ' indicador de fin de "input"
Private bPausa As Boolean       ' indicador de pausa
Private iCodTecla As Integer    ' cdigo tecla pulsada
Private sTxtInput(MAX_INPUT - 1) As String  ' lineas de input guardadas
Private lTxtInput0 As Long                  ' puntero a lnea actual
Private lTxtInput1 As Long                  ' puntero a inicio de buffer de lneas
Private lTxtInput2 As Long                  ' puntero a ltima lnea guardada en buffer (-1 si ninguna)

Private Sub cmdPausa_Click()
    
    bPausa = False
    cmdPausa.Visible = False

End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)

    ' intercepta teclas de control, cursores, escape, etc...
    ' teclas que no son interceptadas por Form_KeyPress
    If (KeyCode >= 33 And KeyCode <= 40) Or _
      (KeyCode >= 112 And KeyCode <= 123) Or _
      KeyCode = 27 Or KeyCode = 45 Or KeyCode = 46 Then
        bPausa = False
        iCodTecla = -1 * KeyCode
    End If

End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
    
    bPausa = False
    iCodTecla = KeyAscii
    
    ' guardamos pulsaciones de teclas si el input no est visible
    If Not txtInput.Visible And KeyAscii >= 32 Then
        txtInput.Text = txtInput.Text & Chr(KeyAscii)
    End If
    
End Sub

Private Sub Form_Load()
    Dim i As Long

    bHayReloj = False
    lDondeInput = -1
    bFinInput = True
    bPausa = False
    lTxtInput0 = 0
    lTxtInput1 = 0
    lTxtInput2 = -1
    For i = 0 To UBound(sTxtInput)
        sTxtInput(i) = Chr(0)
    Next

End Sub

Private Sub Form_Unload(Cancel As Integer)
    
#If Not EsInterprete Then
    Unload frmDebug
#End If

    bFinInput = True
    bPausa = False
    bFinProg = True

End Sub

Private Sub Pantalla_Click(index As Integer)

    ' pasamos el foco a la zona de "input"
    If txtInput.Visible And index = lDondeInput Then
        txtInput.SetFocus
    End If

End Sub

Private Sub Pantalla_Resize(index As Integer)

    If txtInput.Visible And index = lDondeInput Then
        txtInput.Width = Pantalla(index).Width - txtInput.Left - 10
    End If
    
End Sub

Private Sub Reloj_Timer(index As Integer)
    Dim s As String
    
    s = Reloj(index).Tag
    If s <> "" Then
        ' si estamos en mitad de un "input", lo ocultamos temporalmente
        If Not bFinInput Then
            txtInput.Visible = False
        End If
        ' ejecutamos el procedimiento asignado al temporizador
        EjecutaProc s, ""
        ' volvemos a mostrar el "input" si estbamos en mitad de uno
        If Not bFinInput Then
            txtInput.Left = Pantalla(lDondeInput).Left + Pantalla(lDondeInput).CurrentX
            txtInput.Top = Pantalla(lDondeInput).Top + Pantalla(lDondeInput).CurrentY
            txtInput.Width = Pantalla(lDondeInput).Width - txtInput.Left - 10
            txtInput.Visible = True
            txtInput.SetFocus
            If Len(txtInput.Text) > 0 Then
                txtInput.SelStart = Len(txtInput.Text)
            End If
        End If
    End If

End Sub

Private Sub txtInput_KeyDown(KeyCode As Integer, Shift As Integer)
    Dim i As Long
    Dim s As String

    Select Case KeyCode
        Case 13
            ' guardamos la frase tecleada, si no est guardada
            ' ya en la posicin actual
            s = Trim(txtInput.Text)
            If s <> "" Then
                If lTxtInput2 = -1 Then
                    lTxtInput2 = lTxtInput1
                Else
                    lTxtInput2 = lTxtInput2 + 1
                    If lTxtInput2 > UBound(sTxtInput) Or lTxtInput2 = lTxtInput1 Then
                        lTxtInput2 = lTxtInput1
                        lTxtInput1 = lTxtInput1 + 1
                        If lTxtInput1 > UBound(sTxtInput) Then
                            lTxtInput1 = 1
                        End If
                    End If
                End If
                If sTxtInput(lTxtInput2) <> s Then
                    sTxtInput(lTxtInput2) = s
                    lTxtInput0 = lTxtInput2
                End If
            End If
            bFinInput = True
            KeyCode = 0
        Case vbKeyUp
            If lTxtInput2 <> -1 Then
                txtInput.Text = sTxtInput(lTxtInput0)
                txtInput.SelStart = Len(txtInput.Text)
                txtInput.SelLength = 1
                lTxtInput0 = lTxtInput0 - 1
                If lTxtInput2 < lTxtInput1 Then
                    If lTxtInput0 < 0 Then
                        lTxtInput0 = UBound(sTxtInput)
                    End If
                    If lTxtInput0 = lTxtInput2 Then
                        lTxtInput0 = lTxtInput1
                    End If
                Else
                    If lTxtInput0 < lTxtInput1 Then
                        lTxtInput0 = lTxtInput1
                    End If
                End If
            End If
            KeyCode = 0
        Case vbKeyDown
            If lTxtInput2 <> -1 Then
                lTxtInput0 = lTxtInput0 + 1
                If lTxtInput2 < lTxtInput1 Then
                    If lTxtInput0 > UBound(sTxtInput) Then
                        lTxtInput0 = 0
                    End If
                    If lTxtInput0 = lTxtInput1 Then
                        lTxtInput0 = lTxtInput2
                    End If
                Else
                    If lTxtInput0 > lTxtInput2 Then
                        lTxtInput0 = lTxtInput2
                    End If
                End If
                txtInput.Text = sTxtInput(lTxtInput0)
                txtInput.SelStart = Len(txtInput.Text)
                txtInput.SelLength = 1
            End If
            KeyCode = 0
    End Select
    
End Sub

' devuelve la altura actual de los caracteres segn su tipo de letra
Private Function AlturaCar(ByVal lPantalla As Long) As Long
    Const THEIGHT = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789"
    
    AlturaCar = Pantalla(lPantalla).TextHeight(THEIGHT)

End Function

Private Sub SecuenciaEscape(ByVal lPantalla As Long, ByVal sEsc As String)
    Dim i As Integer, j As Integer, iTam As Integer
    Dim lR As Long, lG As Long, lB As Long
    Dim sRGB As String
    
    If lPantalla < 0 Or lPantalla > Pantalla.Count - 1 Then
        Exit Sub
    End If
    
    ' salto de lnea
    If sEsc = ESCAPE_SALTO Then
        ' aqu no hacemos nada, lo haremos en FormateaTexto
    ' negrita
    ElseIf sEsc = ESCAPE_NEGRITA Then
        Pantalla(lPantalla).Font.Bold = Not Pantalla(lPantalla).Font.Bold
    ' cursiva
    ElseIf sEsc = ESCAPE_CURSIVA Then
        Pantalla(lPantalla).Font.Italic = Not Pantalla(lPantalla).Font.Italic
    ' subrayado
    ElseIf sEsc = ESCAPE_SUBRAYADO Then
        Pantalla(lPantalla).Font.Underline = Not Pantalla(lPantalla).Font.Underline
    ' cambio de color
    ElseIf Left(sEsc, Len(ESCAPE_COLOR)) = ESCAPE_COLOR Then
        i = InStr(sEsc, "(")
        j = InStr(sEsc, ")")
        ' entre parntesis debe aparecer RRGGBB
        If j - i - 1 <> 6 Then
            Exit Sub
        End If
        sRGB = Mid(sEsc, i + 1, j - i - 1)
        lR = HexADec(Left(sRGB, 2))
        lG = HexADec(Mid(sRGB, 3, 2))
        lB = HexADec(Right(sRGB, 2))
        If lR < 0 Or lG < 0 Or lB < 0 Then
            Exit Sub
        End If
        Pantalla(lPantalla).ForeColor = RGB(lR, lG, lB)
    ' cambio de color de fondo
    ElseIf Left(sEsc, Len(ESCAPE_COLORF)) = ESCAPE_COLORF Then
        i = InStr(sEsc, "(")
        j = InStr(sEsc, ")")
        ' entre parntesis debe aparecer RRGGBB
        If j - i - 1 <> 6 Then
            Exit Sub
        End If
        sRGB = Mid(sEsc, i + 1, j - i - 1)
        lR = HexADec(Left(sRGB, 2))
        lG = HexADec(Mid(sRGB, 3, 2))
        lB = HexADec(Right(sRGB, 2))
        If lR < 0 Or lG < 0 Or lB < 0 Then
            Exit Sub
        End If
        Pantalla(lPantalla).BackColor = RGB(lR, lG, lB)
    ' cambio de tamao/tipo de letra
    Else
        On Error Resume Next
        Err.Clear
        iTam = CInt(sEsc)
        If Err.Number = 0 Then
            Pantalla(lPantalla).Font.Size = iTam
        Else
            Pantalla(lPantalla).Font.Name = sEsc
        End If
        Err.Clear
    End If

End Sub

' inserta un salto manual donde corresponda para no partir una palabra a medias
' y devuelve la longitud (en twips) de lo que pasa a la lnea siguiente
Private Function InsertaSaltoManual(ByVal lPantalla As Long, sTxt As String) As Long
    Dim bInsertado As Boolean
    Dim lLongitud As Long
    Dim i As Integer
    Dim c As String, s As String

    If lPantalla < 0 Or lPantalla > Pantalla.Count - 1 Then
        Exit Function
    End If

    s = ""
    bInsertado = False
    For i = Len(sTxt) To 1 Step -1
        c = Mid(sTxt, i, 1)
    
        ' lo inserta en el primer espacio que encuentre (empezando por el final)
        If c = " " And Not bInsertado Then
            c = " " & vbLf
            lLongitud = Pantalla(lPantalla).TextWidth(Right(sTxt, Len(sTxt) - i))
            bInsertado = True
        End If
        
        s = c & s
    Next
    
    ' si no insert un salto manual, coloca uno al final de la cadena
    If Not bInsertado Then
        s = s & vbLf
        lLongitud = 0
    End If
    
    sTxt = s
    InsertaSaltoManual = lLongitud

End Function

' formatea el texto, insertando saltos de lnea donde corresponda para no partir
' palabras, devuelve el texto formateado
Private Function FormateaTexto(ByVal lPantalla As Long, ByVal sTxt As String) As String
    Dim F As New StdFont
    Dim i As Long, j As Long, lPosUltEspacio As Long, lX As Long, lMaxX As Long
    Dim c As String, sEscape As String, sTxtF As String
    
    On Error Resume Next
    If lPantalla < 0 Or lPantalla > Pantalla.Count - 1 Then
        Exit Function
    End If
    
    ' guardamos el estado de la pantalla
    F.Name = Pantalla(lPantalla).Font.Name
    F.Size = Pantalla(lPantalla).Font.Size
    F.Bold = Pantalla(lPantalla).Font.Bold
    F.Italic = Pantalla(lPantalla).Font.Italic
    F.Underline = Pantalla(lPantalla).Font.Underline
    
    lPosUltEspacio = -1
    lX = Pantalla(lPantalla).CurrentX
    sTxtF = ""
    lMaxX = Pantalla(lPantalla).ScaleWidth - MARGEN_DER
    For i = 1 To Len(sTxt)
        c = Mid(sTxt, i, 1)
        ' inicio de secuencia de ESCAPE
        If c = ESCAPE1 And Mid(sTxt, i + 1, 1) = ESCAPE2 Then
            ' separamos la secuencia de ESCAPE
            j = InStr(i + 1, sTxt, ESCAPE3)
            If j <> 0 Then
                sEscape = UCase(Mid(sTxt, i + 2, j - i - 2))
                ' caso especial de salto de lnea
                If sEscape = ESCAPE_SALTO Then
                    sTxtF = sTxtF & vbCr
                    lX = 0
                Else
                    ' activamos la secuencia de escape para dejar en condiciones
                    ' reales a la pantalla
                    SecuenciaEscape lPantalla, sEscape
                    sTxtF = sTxtF & ESCAPE1 & ESCAPE2 & sEscape & ESCAPE3
                End If
                ' nos posicionamos detrs del cdigo de ESCAPE
                i = j
            Else
                lX = lX + Pantalla(lPantalla).TextWidth(c)
                If lX > lMaxX Then
                    lX = InsertaSaltoManual(lPantalla, sTxtF)
                End If
                sTxtF = sTxtF & c
            End If
        ElseIf c = vbCr Then
            lX = 0
            sTxtF = sTxtF & c
        ElseIf c = vbLf Then
            ' nos saltamos los LF para que no provoque doble salto de lnea
        Else
            lX = lX + Pantalla(lPantalla).TextWidth(c)
            If lX > lMaxX Then
                lX = InsertaSaltoManual(lPantalla, sTxtF)
            End If
            sTxtF = sTxtF & c
        End If
    Next
    
    ' recuperamos el estado de la pantalla
    Pantalla(lPantalla).Font.Name = F.Name
    Pantalla(lPantalla).Font.Size = F.Size
    Pantalla(lPantalla).Font.Bold = F.Bold
    Pantalla(lPantalla).Font.Italic = F.Italic
    Pantalla(lPantalla).Font.Underline = F.Underline
    
    FormateaTexto = sTxtF
    
End Function

' comprueba si tenemos que hacer "scroll" de la ventana
Private Sub ScrollTexto(ByVal lPantalla As Long)
    Dim i As Long, lLineas As Long, lAltoCar As Long

    ' si no hay que hacer scroll, salimos
    If Pantalla(lPantalla).Tag = "N" Then
        Exit Sub
    End If

    lAltoCar = AlturaCar(lPantalla)
    If Pantalla(lPantalla).CurrentY + lAltoCar >= (Pantalla(lPantalla).Height - MARGEN_INF) Then
        If Pantalla(lPantalla).Tag = "" Then
            cmdPausa.Left = Pantalla(lPantalla).Left + Pantalla(lPantalla).Width - cmdPausa.Width
            cmdPausa.Top = Pantalla(lPantalla).Top + Pantalla(lPantalla).Height - cmdPausa.Height
            cmdPausa.Visible = True
            bPausa = True
            Do While bPausa And EstaCargado(Me)
                DoEvents
            Loop
            Pantalla(lPantalla).Tag = 0
        End If
        
        ' scroll hacia arriba
        BitBlt Pantalla(lPantalla).hDC, 0, 0, Pantalla(lPantalla).ScaleWidth, _
          Pantalla(lPantalla).ScaleHeight - lAltoCar, _
          Pantalla(lPantalla).hDC, 0, lAltoCar, SRCCOPY
        Pantalla(lPantalla).Refresh
        
        Pantalla(lPantalla).Line (0, Pantalla(lPantalla).ScaleHeight - lAltoCar)- _
          Step(Pantalla(lPantalla).ScaleWidth, lAltoCar), Pantalla(lPantalla).BackColor, BF
        
        Pantalla(lPantalla).CurrentX = 0
        Pantalla(lPantalla).CurrentY = Pantalla(lPantalla).ScaleHeight - lAltoCar - MARGEN_INF - 4
        
        ' incrementamos el n de lneas "scrolleadas", si la pantalla no tiene scroll
        ' continuo
        If Pantalla(lPantalla).Tag <> -1 Then
            Pantalla(lPantalla).Tag = Pantalla(lPantalla).Tag + 1
            ' calculamos el n de lneas de la pantalla (no es exacto pero debera ser
            ' muy aproximado)
            lLineas = (Pantalla(lPantalla).ScaleHeight / lAltoCar) - 2
            
            If Pantalla(lPantalla).Tag >= lLineas Then
                Pantalla(lPantalla).Tag = ""
            End If
        End If
    End If
    
End Sub

' inicializa estado
Public Sub Inicializa()

    bFinInput = True
    bPausa = False
    cmdPausa.Visible = False

End Sub

' redimensiona la ventana principal
Public Sub TamVentana(ByVal lAncho As Long, lAlto As Long)

    On Error Resume Next
    
    DoEvents
    Me.Width = lAncho * Screen.TwipsPerPixelX
    Me.Height = lAlto * Screen.TwipsPerPixelY
    Me.Refresh
    
    ' si la ventana es invisible, la muestra
    If Not Me.Visible Then
        DoEvents
        Me.Show
    End If
    
End Sub

' cambia la posicin de la ventana principal
Public Sub PosVentana(ByVal lX As Long, lY As Long)

    On Error Resume Next
        
    ' si la ventana es invisible, la muestra
    If Not Me.Visible Then
        DoEvents
        Me.Show
    End If
    
    Me.Top = lY * Screen.TwipsPerPixelX
    Me.Left = lX * Screen.TwipsPerPixelY
    Me.Refresh
    DoEvents

End Sub

' cambia el fondo de la ventana, si se pasa una cadena de la forma "@rrggbb" pone un
' color de fondo, si es de la forma "#nnnnn" intenta cargar el grfico
' desde el fichero de recursos
Public Sub FondoVentana(ByVal sFondo As String)
    Dim s As String, sRGB As String
    Dim lR As Long, lG As Long, lB As Long, lIDRes As Long

    If Left(sFondo, 1) = "@" Then
        If Len(sFondo) >= 7 Then
            sRGB = Right(sFondo, Len(sFondo) - 1)
            lR = HexADec(Left(sRGB, 2))
            lG = HexADec(Mid(sRGB, 3, 2))
            lB = HexADec(Right(sRGB, 2))
            If lR < 0 Or lG < 0 Or lB < 0 Then
                Exit Sub
            End If
            Me.BackColor = RGB(lR, lG, lB)
        End If
    ElseIf Left(sFondo, 1) = "#" Then
        If Len(sFondo) >= 2 Then
            On Error Resume Next
            s = Right(sFondo, Len(sFondo) - 1)
            lIDRes = CLng(s)
            Set Me.Picture = CargaResImagen(sFichAventura & EXT_DLL, lIDRes)
        End If
    Else
        On Error Resume Next
        Me.Picture = LoadPicture(sFondo)
    End If
    
End Sub

' cambia el borde y el ttulo de la ventana principal
Public Sub EstiloVentana(ByVal lBorde As Long, ByVal sTitulo As String)

    If lBorde = 0 Then
        Me.BorderStyle = 0
    Else
        Me.BorderStyle = 1
    End If
    
    Me.Caption = sTitulo

End Sub

' imprime texto en la ventana, el texto puede tener los siguiente cdigos de ESCAPE:
'
'   \[R]            salto de lnea
'   \[N]            activa/desactiva negrita
'   \[C]            activa/desactiva cursiva
'   \[S]            activa/desactiva subrayado
'   \[RGB(rrggbb)]  cambia color del texto, 'rrggbb'=valor hexadecimal
'   \[RGBF(rrggbb)] cambia color del fondo, 'rrggbb'=valor hexadecimal
'                   (NOTA: se borra la ventana)
'   \[fuente]       cambia tipo de letra, 'fuente'=nombre vlido de fuente
'   \[nn]           cambia tamao de letra, 'nn'=tamao en puntos
'
Public Sub ImprimeTexto(ByVal lPantalla As Long, ByVal sTxt As String)
    Dim i As Long, j As Long
    Dim c As String, c2 As String, sEscape As String
    
    On Error Resume Next
    
    If sTxt = "" Then
        sTxt = vbCr
    Else
        sTxt = FormateaTexto(lPantalla, sTxt)
    End If
    
    For i = 1 To Len(sTxt)
        c = Mid(sTxt, i, 1)
        ' inicio de secuencia de ESCAPE
        If c = ESCAPE1 And Mid(sTxt, i + 1, 1) = ESCAPE2 Then
            ' separamos la secuencia de ESCAPE
            j = InStr(i + 1, sTxt, ESCAPE3)
            If j <> 0 Then
                sEscape = UCase(Mid(sTxt, i + 2, j - i - 2))
                SecuenciaEscape lPantalla, sEscape
                ' nos posicionamos detrs del cdigo de ESCAPE
                i = j
            End If
        Else
            Pantalla(lPantalla).Print c;
        End If
        
        ScrollTexto lPantalla
    Next
    
End Sub

' presenta un indicador de entrada de texto en la "pantalla" indicada
' y recoge el texto tecleado
Public Function LeeInput(ByVal lPantalla As Long, ByVal sPrompt As String) As String
    Dim s As String

    On Error Resume Next

    ' imprimimos el indicador en la "pantalla" adecuada
    lDondeInput = lPantalla
    ImprimeTexto lPantalla, sPrompt
    
    ' ocultamos el indicador de pausa de scroll si est visible
    If cmdPausa.Visible Then
        cmdPausa_Click
    End If
    
    txtInput.Left = Pantalla(lPantalla).Left + Pantalla(lPantalla).CurrentX
    txtInput.Top = Pantalla(lPantalla).Top + Pantalla(lPantalla).CurrentY
    txtInput.Width = Pantalla(lPantalla).Width - txtInput.Left - 10
    txtInput.Height = AlturaCar(lPantalla)
    txtInput.BackColor = Pantalla(lPantalla).BackColor
    txtInput.ForeColor = Pantalla(lPantalla).ForeColor
    Set txtInput.Font = Pantalla(lPantalla).Font
    txtInput.Visible = True
    txtInput.Text = ""
    txtInput.SetFocus
    
    bFinInput = False
    Do While Not bFinInput And EstaCargado(Me)
        DoEvents
    Loop
    
    s = txtInput.Text
    txtInput.Visible = False
    ImprimeTexto lPantalla, s
    ImprimeTexto lPantalla, ""
    LeeInput = s

End Function

' espera a que se pulse una tecla y devuelve el carcter
' o cdigo de la tecla pulsada
Public Function LeeTecla() As String
    Dim bEstadoTimer() As Boolean
    Dim s As String
    Dim i As Long

    On Error Resume Next
   
    ' ocultamos el indicador de pausa de scroll si est visible
    If cmdPausa.Visible Then
        cmdPausa_Click
    End If
    
    ' guardamos el estado de los temporizadores y los desactivamos
    ReDim bEstadoTimer(Reloj.Count - 1)
    For i = 0 To Reloj.Count - 1
        bEstadoTimer(i) = Reloj(i).Enabled
        Reloj(i).Enabled = False
    Next
    
    bPausa = True
    Do While bPausa And EstaCargado(Me)
        DoEvents
    Loop
    
    ' restaura estado de los temporizadores
    For i = 0 To UBound(bEstadoTimer)
        Reloj(i).Enabled = bEstadoTimer(i)
    Next
    
    If iCodTecla = 0 Then
        s = ""
    Else
        If iCodTecla < 0 Then
            Select Case iCodTecla
                Case -27
                    s = "ESC"
                Case -33
                    s = "PARR"
                Case -34
                    s = "PABJ"
                Case -35
                    s = "FIN"
                Case -36
                    s = "INI"
                Case -37
                    s = "IZQ"
                Case -38
                    s = "ARR"
                Case -39
                    s = "DER"
                Case -40
                    s = "ABJ"
                Case -45
                    s = "INS"
                Case -46
                    s = "DEL"
                Case -112, -113, -114, -115, -116, -117, _
                     -118, -119, -120, -121, -122, -123
                    s = "F" & CStr((-1 * iCodTecla) - 111)
            End Select
        Else
            Select Case iCodTecla
                Case 27
                    s = "ESC"
                Case 13
                    s = "ENT"
                Case Else
                    s = Chr(iCodTecla)
            End Select
        End If
    End If
    LeeTecla = s

End Function

' crea una nueva "pantalla" y devuelve su n (-1 si error)
Public Function CreaPantalla() As Long
    Dim i As Long
    
    LockWindowUpdate Me.hwnd
    
    On Error GoTo Error_CreaPantalla
    i = Pantalla.Count
    Load Pantalla(i)
    
    Pantalla(i).Top = 0
    Pantalla(i).Left = 0
    Pantalla(i).Width = Me.ScaleWidth / 2
    Pantalla(i).Width = Me.ScaleHeight / 2
    Set Pantalla(i).Picture = LoadPicture()
    Pantalla(i).Tag = ""
    Pantalla(i).Visible = True
    
    LockWindowUpdate 0
    CreaPantalla = i
    Exit Function

Error_CreaPantalla:
    LockWindowUpdate 0
    CreaPantalla = -1
End Function

' elimina una "pantalla" (si existe)
Public Sub EliminaPantalla(ByVal lPantalla As Long)
    
    ' NOTA: la pantalla 0 no se puede eliminar
    If lPantalla < 1 Or lPantalla > Pantalla.Count - 1 Then
        Exit Sub
    End If
    
    LockWindowUpdate Me.hwnd
    On Error Resume Next
    Unload Pantalla(lPantalla)
    LockWindowUpdate 0

End Sub

' cambia el modo de scroll de una pantalla
' el parmetro 'lScroll' indica el modo de scroll de la pantalla:
'
'   0 - hace pausa para scroll
'   1 - scroll continuo (no hace pausa cuando se llena pero s hace scroll)
'   2 - no tiene scroll (no se hace scroll cuando se llena la pantalla)
Public Sub ModoScrollPantalla(ByVal lPantalla As Long, ByVal lScroll As Long)
    
    If lPantalla < 0 Or lPantalla > Pantalla.Count - 1 Then
        Exit Sub
    End If
    
    Select Case lScroll
        Case 0
            Pantalla(lPantalla).Tag = ""
        Case 1
            Pantalla(lPantalla).Tag = -1
        Case 2
            Pantalla(lPantalla).Tag = "N"
    End Select
    
End Sub

' cambia el tamao de una "pantalla"
Public Sub TamPantalla(ByVal lPantalla As Long, ByVal lAncho As Long, ByVal lAlto As Long)

    If lPantalla < 0 Or lPantalla > Pantalla.Count - 1 Then
        Exit Sub
    End If

    LockWindowUpdate Me.hwnd
    Pantalla(lPantalla).Width = lAncho
    Pantalla(lPantalla).Height = lAlto
    LockWindowUpdate 0

End Sub

' cambia la posicin de una "pantalla"
Public Sub PosPantalla(ByVal lPantalla As Long, ByVal lX As Long, ByVal lY As Long)

    If lPantalla < 0 Or lPantalla > Pantalla.Count - 1 Then
        Exit Sub
    End If
    
    LockWindowUpdate Me.hwnd
    Pantalla(lPantalla).Left = lX
    Pantalla(lPantalla).Top = lY
    LockWindowUpdate 0
    
End Sub

' pone una imagen de fondo en una "pantalla", si 'sImg' es de la forma "#nnnnn"
' se carga el recurso correspondiente desde el fichero de recursos
Public Sub FondoPantalla(ByVal lPantalla As Long, ByVal sImg As String)
    Dim lIDRes As Long
    Dim s As String

    If lPantalla < 0 Or lPantalla > Pantalla.Count - 1 Then
        Exit Sub
    End If
    
    On Error Resume Next
    LockWindowUpdate Me.hwnd
    If Left(sImg, 1) = "#" Then
        If Len(sImg) >= 2 Then
            s = Right(sImg, Len(sImg) - 1)
            lIDRes = CLng(s)
            Set Pantalla(lPantalla).Picture = CargaResImagen(sFichAventura & EXT_DLL, lIDRes)
        End If
    Else
        Set Pantalla(lPantalla).Picture = LoadPicture(sImg)
    End If
    LockWindowUpdate 0

End Sub

' limpia una "pantalla"
Public Sub LimpiaPantalla(ByVal lPantalla As Long)

    LockWindowUpdate Me.hwnd
    Pantalla(lPantalla).Cls
    Set Pantalla(lPantalla).Picture = LoadPicture()
    Pantalla(lPantalla).CurrentX = 0
    Pantalla(lPantalla).CurrentY = 0
    If Pantalla(lPantalla).Tag <> "" And Pantalla(lPantalla).Tag <> "N" Then
        If Pantalla(lPantalla).Tag <> -1 Then
            Pantalla(lPantalla).Tag = ""
        End If
    End If
    LockWindowUpdate 0

End Sub

' fija la posicin de impresin de una "pantalla"
Public Sub PosImpPantalla(ByVal lPantalla As Long, ByVal lX As Long, lY As Long)

    Pantalla(lPantalla).CurrentX = lX
    Pantalla(lPantalla).CurrentY = lY

End Sub

' crea un nuevo reloj con una temporizacin dada para ejecutar un proceso
' devuelve el ID del reloj creado o -1 si error
Public Function CreaReloj(ByVal lTiempo As Long, ByVal sProc As String) As Long
    Dim lReloj As Long

    On Error GoTo Error_Reloj

    If Not bHayReloj Then
        lReloj = 0
        bHayReloj = True
    Else
        lReloj = Reloj.Count
        Load Reloj(lReloj)
    End If
    
    Reloj(lReloj).Tag = sProc
    Reloj(lReloj).Interval = lTiempo
    Reloj(lReloj).Enabled = True
    CreaReloj = lReloj
    Exit Function
    
Error_Reloj:
    CreaReloj = -1
End Function

' para un temporizador
Public Sub ParaReloj(ByVal lReloj As Long)

    If Not bHayReloj Or lReloj < 0 Or lReloj > (Reloj.Count - 1) Then
        Exit Sub
    End If

    Reloj(lReloj).Enabled = False

End Sub

' activa un temporizador
Public Sub ActivaReloj(ByVal lReloj As String)
    
    If Not bHayReloj Or lReloj < 0 Or lReloj > (Reloj.Count - 1) Then
        Exit Sub
    End If
    
    Reloj(lReloj).Enabled = True

End Sub
